package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.reports.CDEStrikePriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(StrikePriceDecimalRule.StrikePriceDecimalRuleDefault.class)
public abstract class StrikePriceDecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceRule cDEStrikePriceRule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetStrikePriceNotationEnumRule getStrikePriceNotationEnumRule;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceDecimalRuleDefault extends StrikePriceDecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(getStrikePriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(cDEStrikePriceRule.evaluate(item.get()), getStrikePriceNotationEnumRule.evaluate(item.get())));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
