package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0101_01")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0101_01.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0101_01 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0101_01";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> PTNG to-string, EventTypeEnum -> CORP to-string ] any = eventType else if actionType = ActionTypeEnum -> MODI to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> UPDT to-string ] any = eventType else if actionType = ActionTypeEnum -> PRTO to-string then EventTypeEnum -> PTNG to-string = eventType else if actionType = ActionTypeEnum -> TERM to-string then [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string ] any = eventType else if [ ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> EROR to-string, ActionTypeEnum -> VALU to-string, ActionTypeEnum -> MARU to-string ] any = actionType then True";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0101_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getEventType", _jFSATransactionReport -> _jFSATransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.UPDT).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getEventType", _jFSATransactionReport -> _jFSATransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(jFSATransactionReport).<String>map("getEventType", _jFSATransactionReport -> _jFSATransactionReport.getEventType()), CardinalityOperator.All);
				}
				if (areEqual(MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getEventType", _jFSATransactionReport -> _jFSATransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MARU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					return ComparisonResult.of(MapperS.of(true));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0101_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
