package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0118_01")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0118_01.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0118_01 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0118_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass <> \"CURR\" then (if [\"YEAR\", \"MNTH\", \"WEEK\", \"DAIL\"] any = floatingRateReferencePeriodOfLeg1TimePeriod then floatingRateReferencePeriodOfLeg1Multiplier exists)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0118_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).and(notEqual(MapperS.of(jFSATransactionReport).<String>map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), MapperS.of("CURR"), CardinalityOperator.Any)).getOrDefault(false)) {
					if (areEqual(MapperC.<String>of(MapperS.of("YEAR"), MapperS.of("MNTH"), MapperS.of("WEEK"), MapperS.of("DAIL")), MapperS.of(jFSATransactionReport).<String>map("getFloatingRateReferencePeriodOfLeg1TimePeriod", _jFSATransactionReport -> _jFSATransactionReport.getFloatingRateReferencePeriodOfLeg1TimePeriod()), CardinalityOperator.Any).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<Integer>map("getFloatingRateReferencePeriodOfLeg1Multiplier", _jFSATransactionReport -> _jFSATransactionReport.getFloatingRateReferencePeriodOfLeg1Multiplier()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0118_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
