package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("PackageTransactionPriceMonetaryOrDecimalOrBasis")
@ImplementedBy(PackageTransactionPriceMonetaryOrDecimalOrBasis.Default.class)
public interface PackageTransactionPriceMonetaryOrDecimalOrBasis extends Validator<PackageTransactionPrice> {
	
	String NAME = "PackageTransactionPriceMonetaryOrDecimalOrBasis";
	String DEFINITION = "optional choice packageTransactionPriceMonetary, packageTransactionPriceDecimal, packageTransactionPriceBasis";
	
	class Default implements PackageTransactionPriceMonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionPrice packageTransactionPrice) {
			ComparisonResult result = executeDataRule(packageTransactionPrice);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionPrice", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionPrice", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PackageTransactionPrice packageTransactionPrice) {
			try {
				return choice(MapperS.of(packageTransactionPrice), Arrays.asList("packageTransactionPriceMonetary", "packageTransactionPriceDecimal", "packageTransactionPriceBasis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PackageTransactionPriceMonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionPrice packageTransactionPrice) {
			return Collections.emptyList();
		}
	}
}
