package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.PriceScheduleReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("PriceScheduleReportMonetaryOrDecimal")
@ImplementedBy(PriceScheduleReportMonetaryOrDecimal.Default.class)
public interface PriceScheduleReportMonetaryOrDecimal extends Validator<PriceScheduleReport> {
	
	String NAME = "PriceScheduleReportMonetaryOrDecimal";
	String DEFINITION = "optional choice priceMonetary, priceDecimal";
	
	class Default implements PriceScheduleReportMonetaryOrDecimal {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceScheduleReport priceScheduleReport) {
			ComparisonResult result = executeDataRule(priceScheduleReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceScheduleReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceScheduleReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PriceScheduleReport priceScheduleReport) {
			try {
				return choice(MapperS.of(priceScheduleReport), Arrays.asList("priceMonetary", "priceDecimal"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PriceScheduleReportMonetaryOrDecimal {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceScheduleReport priceScheduleReport) {
			return Collections.emptyList();
		}
	}
}
