package drr.regulation.mas.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.standards.iosco.cde.reports.CDECurrencyOfExcessCollateralCollectedRule;
import javax.inject.Inject;


@ImplementedBy(CurrencyOfExcessCollateralCollectedRule.CurrencyOfExcessCollateralCollectedRuleDefault.class)
public abstract class CurrencyOfExcessCollateralCollectedRule implements ReportFunction<CollateralReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECurrencyOfExcessCollateralCollectedRule cDECurrencyOfExcessCollateralCollectedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CollateralReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CollateralReportInstruction input);

	public static class CurrencyOfExcessCollateralCollectedRuleDefault extends CurrencyOfExcessCollateralCollectedRule {
		@Override
		protected String doEvaluate(CollateralReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CollateralReportInstruction input) {
			output = cDECurrencyOfExcessCollateralCollectedRule.evaluate(input);
			
			return output;
		}
	}
}
