package drr.regulation.mas.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.mas.rewrite.trade.MASNonReportable;
import drr.regulation.mas.rewrite.trade.validation.MASNonReportableTypeFormatValidator;
import drr.regulation.mas.rewrite.trade.validation.MASNonReportableValidator;
import drr.regulation.mas.rewrite.trade.validation.exists.MASNonReportableOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.52.0
 */
@RosettaMeta(model=MASNonReportable.class)
public class MASNonReportableMeta implements RosettaMetaData<MASNonReportable> {

	@Override
	public List<Validator<? super MASNonReportable>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super MASNonReportable, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super MASNonReportable> validator(ValidatorFactory factory) {
		return factory.<MASNonReportable>create(MASNonReportableValidator.class);
	}

	@Override
	public Validator<? super MASNonReportable> typeFormatValidator(ValidatorFactory factory) {
		return factory.<MASNonReportable>create(MASNonReportableTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super MASNonReportable> validator() {
		return new MASNonReportableValidator();
	}

	@Deprecated
	@Override
	public Validator<? super MASNonReportable> typeFormatValidator() {
		return new MASNonReportableTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super MASNonReportable, Set<String>> onlyExistsValidator() {
		return new MASNonReportableOnlyExistsValidator();
	}
}
