package drr.regulation.mas.rewrite.trade.reports;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDEPaymentFrequencyPeriodRule;
import iso20022.auth030.mas.Frequency13Code__1;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRatePaymentFrequencyPeriodOfLeg2Rule.FloatingRatePaymentFrequencyPeriodOfLeg2RuleDefault.class)
public abstract class FloatingRatePaymentFrequencyPeriodOfLeg2Rule implements ReportFunction<TransactionReportInstruction, Frequency13Code__1> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPaymentFrequencyPeriodRule cDEPaymentFrequencyPeriodRule;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFRA isFRA;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Frequency13Code__1 evaluate(TransactionReportInstruction input) {
		Frequency13Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract Frequency13Code__1 doEvaluate(TransactionReportInstruction input);

	public static class FloatingRatePaymentFrequencyPeriodOfLeg2RuleDefault extends FloatingRatePaymentFrequencyPeriodOfLeg2Rule {
		@Override
		protected Frequency13Code__1 doEvaluate(TransactionReportInstruction input) {
			Frequency13Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected Frequency13Code__1 assignOutput(Frequency13Code__1 output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(interestRateLeg2.evaluate(underlierForProduct.evaluate(item.get())));
					}
					return MapperS.of(interestRateLeg2.evaluate(item.get()));
				});
			final MapperS<InterestRatePayout> thenArg4 = thenArg3
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
			output = thenArg4
				.mapSingleToItem(item -> MapperS.of(cDEPaymentFrequencyPeriodRule.evaluate(item.get())).checkedMap("to-enum", Frequency13Code__1::fromDisplayName, IllegalArgumentException.class)).get();
			
			return output;
		}
	}
}
