package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleValueRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg1ValueRule.NotionalQuantityScheduleLeg1ValueRuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1ValueRule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleValueRule cDENotionalQuantityScheduleValueRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class NotionalQuantityScheduleLeg1ValueRuleDefault extends NotionalQuantityScheduleLeg1ValueRule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleValueRule.evaluate(input);
			
			return output;
		}
	}
}
