package drr.regulation.mas.rewrite.trade.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentTypeRule;
import iso20022.auth030.mas.PaymentType4Code;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentTypeRule.OtherPaymentTypeRuleDefault.class)
public abstract class OtherPaymentTypeRule implements ReportFunction<TransferState, PaymentType4Code> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentTypeRule cDEOtherPaymentTypeRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PaymentType4Code evaluate(TransferState input) {
		PaymentType4Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract PaymentType4Code doEvaluate(TransferState input);

	public static class OtherPaymentTypeRuleDefault extends OtherPaymentTypeRule {
		@Override
		protected PaymentType4Code doEvaluate(TransferState input) {
			PaymentType4Code output = null;
			return assignOutput(output, input);
		}
		
		protected PaymentType4Code assignOutput(PaymentType4Code output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(cDEOtherPaymentTypeRule.evaluate(item.get())).checkedMap("to-enum", PaymentType4Code::fromDisplayName, IllegalArgumentException.class)).get();
			
			return output;
		}
	}
}
