package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEPriceScheduleAmountFormatMonetaryRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule.PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRuleDefault.class)
public abstract class PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceScheduleAmountFormatMonetaryRule cDEPriceScheduleAmountFormatMonetaryRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRuleDefault extends PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEPriceScheduleAmountFormatMonetaryRule.evaluate(input);
			
			return output;
		}
	}
}
