package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;


@ImplementedBy(SourceOfTheIdentifierOfTheBasketConstituentsRule.SourceOfTheIdentifierOfTheBasketConstituentsRuleDefault.class)
public abstract class SourceOfTheIdentifierOfTheBasketConstituentsRule implements ReportFunction<ProductIdentifier, ProductIdTypeEnum> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(ProductIdentifier input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(ProductIdentifier input);

	public static class SourceOfTheIdentifierOfTheBasketConstituentsRuleDefault extends SourceOfTheIdentifierOfTheBasketConstituentsRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(ProductIdentifier input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, ProductIdentifier input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource())).get();
			
			return output;
		}
	}
}
