package drr.regulation.mas.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.MASNonReportable;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class MASNonReportableTypeFormatValidator implements Validator<MASNonReportable> {

	private List<ComparisonResult> getComparisonResults(MASNonReportable o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASNonReportable o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MASNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "MASNonReportable", path, "", res.getError());
				}
				return success("MASNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "MASNonReportable", path, "");
			})
			.collect(toList());
	}

}
