package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0001a_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0001a_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0001a_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0001a_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string, ActionTypeEnum -> PRTO to-string, ActionTypeEnum -> EROR to-string, ActionTypeEnum -> VALU to-string ] any = actionType then (executionAgentOfCounterparty1 <> counterparty1 or executionAgentOfCounterparty1 <> counterparty2 or executionAgentOfCounterparty1 <> dataSubmitter) and (if executionAgentOfCounterparty1 = \"NOAP\" then executionAgentOfCounterparty2DTCC exists)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0001a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (areEqual(MapperS.of(mASTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of("NOAP"), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult = exists(MapperS.of(mASTransactionReport).<String>map("getExecutionAgentOfCounterparty2DTCC", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentOfCounterparty2DTCC()));
					} else {
						ifThenElseResult = ComparisonResult.successEmptyOperand("");
					}
					return notEqual(MapperS.of(mASTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(mASTransactionReport).<String>map("getCounterparty1", _mASTransactionReport -> _mASTransactionReport.getCounterparty1()), CardinalityOperator.Any).or(notEqual(MapperS.of(mASTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(mASTransactionReport).<String>map("getCounterparty2", _mASTransactionReport -> _mASTransactionReport.getCounterparty2()), CardinalityOperator.Any)).or(notEqual(MapperS.of(mASTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(mASTransactionReport).<String>map("getDataSubmitter", _mASTransactionReport -> _mASTransactionReport.getDataSubmitter()), CardinalityOperator.Any)).and(ifThenElseResult);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0001a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
