package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0025_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0025_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0025_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0025_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and (assetClass = \"INTR\" and contractType = \"SWAP\") then if fixedRateOfLeg1 is absent and fixedRateOfLeg2 is absent and spreadOfLeg1 is absent then (spreadOfLeg2 -> spreadOfLeg2Monetary exists or spreadOfLeg2 -> spreadOfLeg2Decimal exists or spreadOfLeg2 -> spreadOfLeg2Basis exists) else if fixedRateOfLeg2 exists then (spreadOfLeg2 -> spreadOfLeg2Monetary is absent and spreadOfLeg2 -> spreadOfLeg2Decimal is absent and spreadOfLeg2 -> spreadOfLeg2Basis is absent)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0025_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), MapperS.of("SWAP"), CardinalityOperator.All))).getOrDefault(false)) {
					if (notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg1", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg1())).and(notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg2()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()))).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary())).or(exists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Decimal", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Decimal()))).or(exists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Basis", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Basis())));
					}
					if (exists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg2())).getOrDefault(false)) {
						return notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary())).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Decimal", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Decimal()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Basis", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Basis())));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0025_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
