package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0040_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0040_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0040_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0040_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and cleared = \"Y\" then centralCounterparty exists and centralCounterparty <> clearingMember else if cleared = \"N\" then centralCounterparty is absent";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0040_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getCleared", _mASTransactionReport -> _mASTransactionReport.getCleared()), MapperS.of("Y"), CardinalityOperator.All)).getOrDefault(false)) {
					return exists(MapperS.of(mASTransactionReport).<String>map("getCentralCounterparty", _mASTransactionReport -> _mASTransactionReport.getCentralCounterparty())).and(notEqual(MapperS.of(mASTransactionReport).<String>map("getCentralCounterparty", _mASTransactionReport -> _mASTransactionReport.getCentralCounterparty()), MapperS.of(mASTransactionReport).<String>map("getClearingMember", _mASTransactionReport -> _mASTransactionReport.getClearingMember()), CardinalityOperator.Any));
				}
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getCleared", _mASTransactionReport -> _mASTransactionReport.getCleared()), MapperS.of("N"), CardinalityOperator.All).getOrDefault(false)) {
					return notExists(MapperS.of(mASTransactionReport).<String>map("getCentralCounterparty", _mASTransactionReport -> _mASTransactionReport.getCentralCounterparty()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0040_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
