package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.NotionalAmountScheduleLeg1Report;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0076a_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0076a_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0076a_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0076a_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then (if notionalAmountScheduleLeg1DTCC -> amount count <> notionalAmountScheduleLeg1DTCC -> effectiveDate count then False) and if [\"CRDT\", \"EQUI\", \"CURR\", \"INTR\"] any = assetClass and notionalAmountScheduleLeg1DTCC exists then notionalAmountScheduleLeg1DTCC -> amount all >= 0";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0076a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (notEqual(MapperS.of(MapperS.of(mASTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1DTCC", _mASTransactionReport -> _mASTransactionReport.getNotionalAmountScheduleLeg1DTCC()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1DTCC", _mASTransactionReport -> _mASTransactionReport.getNotionalAmountScheduleLeg1DTCC()).<Date>map("getEffectiveDate", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getEffectiveDate()).resultCount()), CardinalityOperator.Any).getOrDefault(false)) {
						ifThenElseResult0 = ComparisonResult.of(MapperS.of(false));
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (areEqual(MapperC.<String>of(MapperS.of("CRDT"), MapperS.of("EQUI"), MapperS.of("CURR"), MapperS.of("INTR")), MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), CardinalityOperator.Any).and(exists(MapperS.of(mASTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1DTCC", _mASTransactionReport -> _mASTransactionReport.getNotionalAmountScheduleLeg1DTCC()))).getOrDefault(false)) {
						ifThenElseResult1 = greaterThanEquals(MapperS.of(mASTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1DTCC", _mASTransactionReport -> _mASTransactionReport.getNotionalAmountScheduleLeg1DTCC()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All);
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0076a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
