package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.regulation.mas.rewrite.trade.StrikePriceAndNotation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0094_02")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0094_02.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0094_02 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0094_02";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and ((assetClass = \"INTR\" and [\"FORW\", \"OTHR\"] any = contractType) or ([\"EQUI\", \"COMM\"] any = assetClass and \"OTHR\" = contractType)) then (if fixedRateOfLeg1 is absent and fixedRateOfLeg2 is absent and spreadOfLeg1 is absent and spreadOfLeg2 is absent and strikePrice is absent and optionPremiumAmount is absent then price exists else if priceSchedule -> priceMonetary exists or priceSchedule -> priceDecimal exists then price exists)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0094_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All).and(areEqual(MapperC.<String>of(MapperS.of("FORW"), MapperS.of("OTHR")), MapperS.of(mASTransactionReport).<String>map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), CardinalityOperator.Any)).or(areEqual(MapperC.<String>of(MapperS.of("EQUI"), MapperS.of("COMM")), MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), CardinalityOperator.Any).and(areEqual(MapperS.of("OTHR"), MapperS.of(mASTransactionReport).<String>map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), CardinalityOperator.All)))).getOrDefault(false)) {
					if (notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg1", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg1())).and(notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getFixedRateOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRateOfLeg2()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()))).and(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()))).and(notExists(MapperS.of(mASTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _mASTransactionReport -> _mASTransactionReport.getStrikePrice()))).and(notExists(MapperS.of(mASTransactionReport).<BigDecimal>map("getOptionPremiumAmount", _mASTransactionReport -> _mASTransactionReport.getOptionPremiumAmount()))).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<PriceAndNotation>map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice()));
					}
					if (exists(MapperS.of(mASTransactionReport).<PriceScheduleReport>mapC("getPriceSchedule", _mASTransactionReport -> _mASTransactionReport.getPriceSchedule()).<BigDecimal>map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary())).or(exists(MapperS.of(mASTransactionReport).<PriceScheduleReport>mapC("getPriceSchedule", _mASTransactionReport -> _mASTransactionReport.getPriceSchedule()).<BigDecimal>map("getPriceDecimal", priceScheduleReport -> priceScheduleReport.getPriceDecimal()))).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<PriceAndNotation>map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0094_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
