package drr.regulation.techsprint.g20.mas.functions;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.techsprint.g20.mas.Trader;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(LookupTraderDetails.LookupTraderDetailsDefault.class)
public abstract class LookupTraderDetails implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param id 
	* @return traderDetails 
	*/
	public Trader evaluate(AssignedIdentifier id) {
		Trader.TraderBuilder traderDetailsBuilder = doEvaluate(id);
		
		final Trader traderDetails;
		if (traderDetailsBuilder == null) {
			traderDetails = null;
		} else {
			traderDetails = traderDetailsBuilder.build();
			objectValidator.validate(Trader.class, traderDetails);
		}
		
		return traderDetails;
	}

	protected abstract Trader.TraderBuilder doEvaluate(AssignedIdentifier id);

	public static class LookupTraderDetailsDefault extends LookupTraderDetails {
		@Override
		protected Trader.TraderBuilder doEvaluate(AssignedIdentifier id) {
			Trader.TraderBuilder traderDetails = Trader.builder();
			return assignOutput(traderDetails, id);
		}
		
		protected Trader.TraderBuilder assignOutput(Trader.TraderBuilder traderDetails, AssignedIdentifier id) {
			return Optional.ofNullable(traderDetails)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
