package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRateDayCountLeg2Rule.InterestRateDayCountLeg2RuleDefault.class)
public abstract class InterestRateDayCountLeg2Rule implements ReportFunction<TransactionReportInstruction, DayCountFractionEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg2Rule fixedFloatLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public DayCountFractionEnum evaluate(TransactionReportInstruction input) {
		DayCountFractionEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract DayCountFractionEnum doEvaluate(TransactionReportInstruction input);

	public static class InterestRateDayCountLeg2RuleDefault extends InterestRateDayCountLeg2Rule {
		@Override
		protected DayCountFractionEnum doEvaluate(TransactionReportInstruction input) {
			DayCountFractionEnum output = null;
			return assignOutput(output, input);
		}
		
		protected DayCountFractionEnum assignOutput(DayCountFractionEnum output, TransactionReportInstruction input) {
			final MapperS<InterestRatePayout> thenArg0 = MapperS.of(fixedFloatLeg2Rule.evaluate(input));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
			final FieldWithMetaDayCountFractionEnum fieldWithMetaDayCountFractionEnum = thenArg1
				.mapSingleToItem(item -> item.<FieldWithMetaDayCountFractionEnum>map("getDayCountFraction", interestRatePayout -> interestRatePayout.getDayCountFraction())).get();
			if (fieldWithMetaDayCountFractionEnum == null) {
				output = null;
			} else {
				output = fieldWithMetaDayCountFractionEnum.getValue();
			}
			
			return output;
		}
	}
}
