package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.CalculationPeriodDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRateResetFrequencyMultiplierLeg1Rule.InterestRateResetFrequencyMultiplierLeg1RuleDefault.class)
public abstract class InterestRateResetFrequencyMultiplierLeg1Rule implements ReportFunction<TransactionReportInstruction, Integer> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg1Rule fixedFloatLeg1Rule;
	@Inject protected IsInterestRatePayoutRule isInterestRatePayoutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Integer evaluate(TransactionReportInstruction input) {
		Integer output = doEvaluate(input);
		
		return output;
	}

	protected abstract Integer doEvaluate(TransactionReportInstruction input);

	public static class InterestRateResetFrequencyMultiplierLeg1RuleDefault extends InterestRateResetFrequencyMultiplierLeg1Rule {
		@Override
		protected Integer doEvaluate(TransactionReportInstruction input) {
			Integer output = null;
			return assignOutput(output, input);
		}
		
		protected Integer assignOutput(Integer output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isInterestRatePayoutRule.evaluate(item.get()));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(fixedFloatLeg1Rule.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			output = thenArg2
				.mapSingleToItem(item -> item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<Integer>map("getPeriodMultiplier", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriodMultiplier())).get();
			
			return output;
		}
	}
}
