package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.CalculationPeriodDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRateResetFrequencyPeriodLeg2Rule.InterestRateResetFrequencyPeriodLeg2RuleDefault.class)
public abstract class InterestRateResetFrequencyPeriodLeg2Rule implements ReportFunction<TransactionReportInstruction, PeriodExtendedEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg2Rule fixedFloatLeg2Rule;
	@Inject protected IsInterestRatePayoutRule isInterestRatePayoutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PeriodExtendedEnum evaluate(TransactionReportInstruction input) {
		PeriodExtendedEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PeriodExtendedEnum doEvaluate(TransactionReportInstruction input);

	public static class InterestRateResetFrequencyPeriodLeg2RuleDefault extends InterestRateResetFrequencyPeriodLeg2Rule {
		@Override
		protected PeriodExtendedEnum doEvaluate(TransactionReportInstruction input) {
			PeriodExtendedEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PeriodExtendedEnum assignOutput(PeriodExtendedEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isInterestRatePayoutRule.evaluate(item.get()));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(fixedFloatLeg2Rule.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
			output = thenArg2
				.mapSingleToItem(item -> item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod())).get();
			
			return output;
		}
	}
}
