package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(ReportingPartyIsInSingaporeRule.ReportingPartyIsInSingaporeRuleDefault.class)
public abstract class ReportingPartyIsInSingaporeRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BookingLocationAddressRule bookingLocationAddressRule;
	@Inject protected IsAddressInSingaporeRule isAddressInSingaporeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class ReportingPartyIsInSingaporeRuleDefault extends ReportingPartyIsInSingaporeRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<Address> thenArg = MapperS.of(bookingLocationAddressRule.evaluate(input));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(isAddressInSingaporeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
