package drr.standards.iosco.cde.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.Price;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStrike;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDEEquityOptionNotional.CDEEquityOptionNotionalDefault.class)
public abstract class CDEEquityOptionNotional implements RosettaFunction {

	/**
	* @param optionPayout 
	* @return amount 
	*/
	public BigDecimal evaluate(List<? extends OptionPayout> optionPayout) {
		BigDecimal amount = doEvaluate(optionPayout);
		
		return amount;
	}

	protected abstract BigDecimal doEvaluate(List<? extends OptionPayout> optionPayout);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends OptionPayout> optionPayout);

	protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends OptionPayout> optionPayout);

	public static class CDEEquityOptionNotionalDefault extends CDEEquityOptionNotional {
		@Override
		protected BigDecimal doEvaluate(List<? extends OptionPayout> optionPayout) {
			if (optionPayout == null) {
				optionPayout = Collections.emptyList();
			}
			BigDecimal amount = null;
			return assignOutput(amount, optionPayout);
		}
		
		protected BigDecimal assignOutput(BigDecimal amount, List<? extends OptionPayout> optionPayout) {
			if (exists(quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(false)) {
				amount = multipliedQuantity(optionPayout).get();
			} else if (exists(quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
				amount = MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(multipliedQuantity(optionPayout), MapperC.<OptionPayout>of(optionPayout).<OptionExercise>map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).<BigDecimal>map("getValue", price -> price.getValue())).get();
			} else {
				amount = null;
			}
			
			return amount;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends OptionPayout> optionPayout) {
			return MapperS.of(MapperC.of(optionPayout).get()).<ResolvablePriceQuantity>map("getPriceQuantity", _optionPayout -> _optionPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
		}
		
		@Override
		protected MapperS<BigDecimal> multipliedQuantity(List<? extends OptionPayout> optionPayout) {
			if (exists(quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(false)) {
				return MapperMaths.<BigDecimal, BigDecimal, BigDecimal>multiply(quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).<BigDecimal>map("getValue", measure -> measure.getValue()));
			}
			return quantity(optionPayout).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
		}
	}
}
