package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;


@ImplementedBy(CDECurrencyOfExcessCollateralCollectedRule.CDECurrencyOfExcessCollateralCollectedRuleDefault.class)
public abstract class CDECurrencyOfExcessCollateralCollectedRule implements ReportFunction<CollateralReportInstruction, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CollateralReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CollateralReportInstruction input);

	public static class CDECurrencyOfExcessCollateralCollectedRuleDefault extends CDECurrencyOfExcessCollateralCollectedRule {
		@Override
		protected String doEvaluate(CollateralReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CollateralReportInstruction input) {
			output = "";
			
			return output;
		}
	}
}
