package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.standards.iosco.cde.functions.ExtractCDEPutAmount;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;


@ImplementedBy(CDEPutAmountRule.CDEPutAmountRuleDefault.class)
public abstract class CDEPutAmountRule implements ReportFunction<Trade, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractCDEPutAmount extractCDEPutAmount;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(Trade input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(Trade input);

	public static class CDEPutAmountRuleDefault extends CDEPutAmountRule {
		@Override
		protected BigDecimal doEvaluate(Trade input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, Trade input) {
			final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
			final MapperS<BigDecimal> thenArg = MapperS.of(extractCDEPutAmount.evaluate(input, (bigInteger == null ? null : new BigDecimal(bigInteger))));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
