package drr.standards.iosco.cde.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Contract_StrikePrice;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDEStrikePriceRule.CDEStrikePriceRuleDefault.class)
public abstract class CDEStrikePriceRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class CDEStrikePriceRuleDefault extends CDEStrikePriceRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = MapperC.<PriceSchedule>of(contract_StrikePrice.evaluate(input)).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get();
			
			return output;
		}
	}
}
