package iso20022.auth030.esma.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.AssetClassCommodityIndustrialProduct2Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityIndustrialProduct2ChoiceChoice")
@ImplementedBy(AssetClassCommodityIndustrialProduct2ChoiceChoice.Default.class)
public interface AssetClassCommodityIndustrialProduct2ChoiceChoice extends Validator<AssetClassCommodityIndustrialProduct2Choice> {
	
	String NAME = "AssetClassCommodityIndustrialProduct2ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityIndustrialProduct2Choice> validate(RosettaPath path, AssetClassCommodityIndustrialProduct2Choice assetClassCommodityIndustrialProduct2Choice);
	
	class Default implements AssetClassCommodityIndustrialProduct2ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityIndustrialProduct2Choice> validate(RosettaPath path, AssetClassCommodityIndustrialProduct2Choice assetClassCommodityIndustrialProduct2Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityIndustrialProduct2Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityIndustrialProduct2Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityIndustrialProduct2Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityIndustrialProduct2Choice assetClassCommodityIndustrialProduct2Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityIndustrialProduct2Choice), Arrays.asList("cnstrctn", "manfctg"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityIndustrialProduct2ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityIndustrialProduct2Choice> validate(RosettaPath path, AssetClassCommodityIndustrialProduct2Choice assetClassCommodityIndustrialProduct2Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityIndustrialProduct2Choice", path, DEFINITION);
		}
	}
}
