package iso20022.auth030.esma.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.CommonTradeDataReport69__5;
import iso20022.auth030.esma.CounterpartySpecificData36__1;
import iso20022.auth030.esma.ModificationLevel1Code__1;
import iso20022.auth030.esma.TradeData42__5;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class TradeData42__5OnlyExistsValidator implements ValidatorWithArg<TradeData42__5, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends TradeData42__5> ValidationResult<TradeData42__5> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("ctrPtySpcfcData", ExistenceChecker.isSet((CounterpartySpecificData36__1) o.getCtrPtySpcfcData()))
				.put("cmonTradData", ExistenceChecker.isSet((CommonTradeDataReport69__5) o.getCmonTradData()))
				.put("lvl", ExistenceChecker.isSet((ModificationLevel1Code__1) o.getLvl()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("TradeData42__5", ValidationType.ONLY_EXISTS, "TradeData42__5", path, "");
		}
		return failure("TradeData42__5", ValidationType.ONLY_EXISTS, "TradeData42__5", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
