package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassDetailedSubProductType5Code;
import iso20022.auth030.fca.AssetClassProductType2Code;
import iso20022.auth030.fca.AssetClassSubProductType6Code;
import iso20022.auth030.fca.EnergyCommodityElectricity2__1;
import iso20022.auth030.fca.EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder;
import iso20022.auth030.fca.EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1BuilderImpl;
import iso20022.auth030.fca.EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Impl;
import iso20022.auth030.fca.meta.EnergyCommodityElectricity2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type electricity.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityElectricity2__1", builder=EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityElectricity2__1 extends RosettaModelObject {

	EnergyCommodityElectricity2__1Meta metaData = new EnergyCommodityElectricity2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType6Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType5Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityElectricity2__1 build();
	
	EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder toBuilder();
	
	static EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder builder() {
		return new EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityElectricity2__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends EnergyCommodityElectricity2__1> getType() {
		return EnergyCommodityElectricity2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType6Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType5Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityElectricity2__1Builder extends EnergyCommodityElectricity2__1, RosettaModelObjectBuilder {
		EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setSubPdct(AssetClassSubProductType6Code subPdct);
		EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType5Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType6Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType5Code.class, getAddtlSubPdct(), this);
		}
		

		EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityElectricity2__1  ***********************/
	class EnergyCommodityElectricity2__1Impl implements EnergyCommodityElectricity2__1 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType6Code subPdct;
		private final AssetClassDetailedSubProductType5Code addtlSubPdct;
		
		protected EnergyCommodityElectricity2__1Impl(EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType6Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType5Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public EnergyCommodityElectricity2__1 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder toBuilder() {
			EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityElectricity2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityElectricity2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityElectricity2__1  ***********************/
	class EnergyCommodityElectricity2__1BuilderImpl implements EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType6Code subPdct;
		protected AssetClassDetailedSubProductType5Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType6Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType5Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setSubPdct(AssetClassSubProductType6Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType5Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityElectricity2__1 build() {
			return new EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Impl(this);
		}
		
		@Override
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder o = (EnergyCommodityElectricity2__1.EnergyCommodityElectricity2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityElectricity2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityElectricity2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
