package iso20022.auth030.fca.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.fca.InterestComputationMethod4Code;
import iso20022.auth030.fca.InterestComputationMethodFormat7__1;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class InterestComputationMethodFormat7__1OnlyExistsValidator implements ValidatorWithArg<InterestComputationMethodFormat7__1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends InterestComputationMethodFormat7__1> ValidationResult<InterestComputationMethodFormat7__1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("cd", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getCd()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("InterestComputationMethodFormat7__1", ValidationType.ONLY_EXISTS, "InterestComputationMethodFormat7__1", path, "");
		}
		return failure("InterestComputationMethodFormat7__1", ValidationType.ONLY_EXISTS, "InterestComputationMethodFormat7__1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
