package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.AssetClassDetailedSubProductType33Code;
import iso20022.auth030.hkma.tr.AssetClassProductType4Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType31Code;
import iso20022.auth030.hkma.tr.FreightCommodityDry3;
import iso20022.auth030.hkma.tr.FreightCommodityDry3.FreightCommodityDry3Builder;
import iso20022.auth030.hkma.tr.FreightCommodityDry3.FreightCommodityDry3BuilderImpl;
import iso20022.auth030.hkma.tr.FreightCommodityDry3.FreightCommodityDry3Impl;
import iso20022.auth030.hkma.tr.meta.FreightCommodityDry3Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of a freight derivative of type dry.
 * @version ${project.version}
 */
@RosettaDataType(value="FreightCommodityDry3", builder=FreightCommodityDry3.FreightCommodityDry3BuilderImpl.class, version="${project.version}")
public interface FreightCommodityDry3 extends RosettaModelObject {

	FreightCommodityDry3Meta metaData = new FreightCommodityDry3Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType4Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType31Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType33Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	FreightCommodityDry3 build();
	
	FreightCommodityDry3.FreightCommodityDry3Builder toBuilder();
	
	static FreightCommodityDry3.FreightCommodityDry3Builder builder() {
		return new FreightCommodityDry3.FreightCommodityDry3BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FreightCommodityDry3> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends FreightCommodityDry3> getType() {
		return FreightCommodityDry3.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType4Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType31Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType33Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FreightCommodityDry3Builder extends FreightCommodityDry3, RosettaModelObjectBuilder {
		FreightCommodityDry3.FreightCommodityDry3Builder setBasePdct(AssetClassProductType4Code basePdct);
		FreightCommodityDry3.FreightCommodityDry3Builder setSubPdct(AssetClassSubProductType31Code subPdct);
		FreightCommodityDry3.FreightCommodityDry3Builder setAddtlSubPdct(AssetClassDetailedSubProductType33Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType4Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType31Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType33Code.class, getAddtlSubPdct(), this);
		}
		

		FreightCommodityDry3.FreightCommodityDry3Builder prune();
	}

	/*********************** Immutable Implementation of FreightCommodityDry3  ***********************/
	class FreightCommodityDry3Impl implements FreightCommodityDry3 {
		private final AssetClassProductType4Code basePdct;
		private final AssetClassSubProductType31Code subPdct;
		private final AssetClassDetailedSubProductType33Code addtlSubPdct;
		
		protected FreightCommodityDry3Impl(FreightCommodityDry3.FreightCommodityDry3Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType4Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType31Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType33Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public FreightCommodityDry3 build() {
			return this;
		}
		
		@Override
		public FreightCommodityDry3.FreightCommodityDry3Builder toBuilder() {
			FreightCommodityDry3.FreightCommodityDry3Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FreightCommodityDry3.FreightCommodityDry3Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FreightCommodityDry3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FreightCommodityDry3 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FreightCommodityDry3  ***********************/
	class FreightCommodityDry3BuilderImpl implements FreightCommodityDry3.FreightCommodityDry3Builder {
	
		protected AssetClassProductType4Code basePdct;
		protected AssetClassSubProductType31Code subPdct;
		protected AssetClassDetailedSubProductType33Code addtlSubPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType4Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType31Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public AssetClassDetailedSubProductType33Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public FreightCommodityDry3.FreightCommodityDry3Builder setBasePdct(AssetClassProductType4Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public FreightCommodityDry3.FreightCommodityDry3Builder setSubPdct(AssetClassSubProductType31Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("addtlSubPdct")
		public FreightCommodityDry3.FreightCommodityDry3Builder setAddtlSubPdct(AssetClassDetailedSubProductType33Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public FreightCommodityDry3 build() {
			return new FreightCommodityDry3.FreightCommodityDry3Impl(this);
		}
		
		@Override
		public FreightCommodityDry3.FreightCommodityDry3Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FreightCommodityDry3.FreightCommodityDry3Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FreightCommodityDry3.FreightCommodityDry3Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FreightCommodityDry3.FreightCommodityDry3Builder o = (FreightCommodityDry3.FreightCommodityDry3Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FreightCommodityDry3 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FreightCommodityDry3Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
