package iso20022.auth030.jfsa.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.jfsa.ClearingPartyAndTime22Choice__2;
import iso20022.auth030.jfsa.ClearingPartyAndTime23__2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class ClearingPartyAndTime22Choice__2Validator implements Validator<ClearingPartyAndTime22Choice__2> {

	private List<ComparisonResult> getComparisonResults(ClearingPartyAndTime22Choice__2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("dtls", (ClearingPartyAndTime23__2) o.getDtls() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<ClearingPartyAndTime22Choice__2> validate(RosettaPath path, ClearingPartyAndTime22Choice__2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("ClearingPartyAndTime22Choice__2", ValidationType.CARDINALITY, "ClearingPartyAndTime22Choice__2", path, "", error);
		}
		return success("ClearingPartyAndTime22Choice__2", ValidationType.CARDINALITY, "ClearingPartyAndTime22Choice__2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingPartyAndTime22Choice__2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ClearingPartyAndTime22Choice__2", ValidationType.CARDINALITY, "ClearingPartyAndTime22Choice__2", path, "", res.getError());
				}
				return success("ClearingPartyAndTime22Choice__2", ValidationType.CARDINALITY, "ClearingPartyAndTime22Choice__2", path, "");
			})
			.collect(toList());
	}

}
