package iso20022.auth030.mas.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.mas.ContractType15__2;
import iso20022.auth030.mas.FinancialInstrumentContractType2Code;
import iso20022.auth030.mas.ProductType4Code__1;
import iso20022.auth030.mas.SecurityIdentification46__2;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ContractType15__2OnlyExistsValidator implements ValidatorWithArg<ContractType15__2, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ContractType15__2> ValidationResult<ContractType15__2> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("ctrctTp", ExistenceChecker.isSet((FinancialInstrumentContractType2Code) o.getCtrctTp()))
				.put("asstClss", ExistenceChecker.isSet((ProductType4Code__1) o.getAsstClss()))
				.put("pdctId", ExistenceChecker.isSet((SecurityIdentification46__2) o.getPdctId()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ContractType15__2", ValidationType.ONLY_EXISTS, "ContractType15__2", path, "");
		}
		return failure("ContractType15__2", ValidationType.ONLY_EXISTS, "ContractType15__2", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
