# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['DividendTerms']


class DividendTerms(BaseDataClass):
    """
    Information related to dividends and payments.
    """
    manufacturedIncomeRequirement: cdm.product.asset.DividendPayoutRatio.DividendPayoutRatio = Field(..., description="Specifies the proportion of the value of the dividend on the borrowed shares that the borrower is legally obligated to return to the lender.")
    """
    Specifies the proportion of the value of the dividend on the borrowed shares that the borrower is legally obligated to return to the lender.
    """
    dividendEntitlement: Optional[cdm.product.asset.DividendEntitlementEnum.DividendEntitlementEnum] = Field(None, description="Defines the date on which the receiver of the equity return is entitled to the dividend.")
    """
    Defines the date on which the receiver of the equity return is entitled to the dividend.
    """
    minimumBillingAmount: Optional[cdm.observable.asset.Money.Money] = Field(None, description="daily fee increments accrue until a threshold is crossed, at which point payment becomes due)")
    """
    daily fee increments accrue until a threshold is crossed, at which point payment becomes due)
    """

import cdm 
import cdm.product.asset.DividendPayoutRatio
import cdm.product.asset.DividendEntitlementEnum
import cdm.observable.asset.Money
