# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExerciseFeeSchedule']

from cdm.base.staticdata.party.PayerReceiver import PayerReceiver

class ExerciseFeeSchedule(PayerReceiver):
    """
    A class to define a fee or schedule of fees to be payable on the exercise of an option. This fee may be defined as an amount or a percentage of the notional exercised. As a difference with FpML, it extends the BuyerSeller class.
    """
    notionalReference: AttributeWithReference | cdm.observable.asset.Money.Money = Field(..., description="A pointer style reference to the associated notional schedule defined elsewhere in the document.")
    """
    A pointer style reference to the associated notional schedule defined elsewhere in the document.
    """
    feeAmountSchedule: Optional[cdm.product.common.schedule.AmountSchedule.AmountSchedule] = Field(None, description="The exercise fee amount schedule. The fees are expressed as currency amounts. The currency of the fee is assumed to be that of the notional schedule referenced.")
    """
    The exercise fee amount schedule. The fees are expressed as currency amounts. The currency of the fee is assumed to be that of the notional schedule referenced.
    """
    feeRateSchedule: Optional[cdm.base.math.Schedule.Schedule] = Field(None, description="The exercise free rate schedule. The fees are expressed as percentage rates of the notional being exercised. The currency of the fee is assumed to be that of the notional schedule referenced.")
    """
    The exercise free rate schedule. The fees are expressed as percentage rates of the notional being exercised. The currency of the fee is assumed to be that of the notional schedule referenced.
    """
    feePaymentDate: cdm.base.datetime.RelativeDateOffset.RelativeDateOffset = Field(..., description="The date on which exercise fee(s) will be paid. It is specified as a relative date.")
    """
    The date on which exercise fee(s) will be paid. It is specified as a relative date.
    """
    
    @rosetta_condition
    def condition_0_ExerciseFeeScheduleChoice(self):
        """
        Choice rule to represent an FpML choice construct.
        """
        item = self
        return rosetta_check_one_of(self, 'feeAmountSchedule', 'feeRateSchedule', necessity=True)

import cdm 
import cdm.observable.asset.Money
import cdm.product.common.schedule.AmountSchedule
import cdm.base.math.Schedule
import cdm.base.datetime.RelativeDateOffset
