# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExercisePeriod']


class ExercisePeriod(BaseDataClass):
    """
    This defines the time interval to the start of the exercise period, i.e. the earliest exercise date, and the frequency of subsequent exercise dates (if any).
    """
    earliestExerciseDateTenor: cdm.base.datetime.Period.Period = Field(..., description="The time interval to the first (and possibly only) exercise date in the exercise period.")
    """
    The time interval to the first (and possibly only) exercise date in the exercise period.
    """
    exerciseFrequency: Optional[cdm.base.datetime.Period.Period] = Field(None, description="The frequency of subsequent exercise dates in the exercise period following the earliest exercise date. An interval of 1 day should be used to indicate an American style exercise period.")
    """
    The frequency of subsequent exercise dates in the exercise period following the earliest exercise date. An interval of 1 day should be used to indicate an American style exercise period.
    """

import cdm 
import cdm.base.datetime.Period
