# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExtensionEvent']


class ExtensionEvent(BaseDataClass):
    """
    A data to:  define the adjusted dates associated with an individual extension event.
    """
    adjustedExerciseDate: datetime.date = Field(..., description="The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.")
    """
    The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
    """
    adjustedExtendedTerminationDate: datetime.date = Field(..., description="The termination date if an extendible provision is exercised. This date should already be adjusted for any applicable business day convention.")
    """
    The termination date if an extendible provision is exercised. This date should already be adjusted for any applicable business day convention.
    """
    
    @rosetta_condition
    def condition_0_FpML_ird_42(self):
        """
        FpML validation rule ird-42 - adjustedExerciseDate must be before adjustedExtendedTerminationDate.
        """
        item = self
        return all_elements(rosetta_resolve_attr(self, "adjustedExerciseDate"), "<", rosetta_resolve_attr(self, "adjustedExtendedTerminationDate"))

import cdm 
