# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionExercise']


class OptionExercise(BaseDataClass):
    """
     A class to represent the applicable terms to qualify an option exercise: the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
    """
    optionStyle: cdm.product.template.OptionStyle.OptionStyle = Field(..., description="The option exercise can be of American style, Bermuda style or European style. The FpML implementation makes use of a substitution group.")
    """
    The option exercise can be of American style, Bermuda style or European style. The FpML implementation makes use of a substitution group.
    """
    strike: Optional[cdm.product.template.OptionStrike.OptionStrike] = Field(None, description="Specifies the strike of the option on credit default swap.")
    """
    Specifies the strike of the option on credit default swap.
    """
    exerciseProcedure: Optional[cdm.product.template.ExerciseProcedure.ExerciseProcedure] = Field(None, description="The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.")
    """
    The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.
    """

import cdm 
import cdm.product.template.OptionStyle
import cdm.product.template.OptionStrike
import cdm.product.template.ExerciseProcedure
