/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.PeriodAdditionConvention;
import com.opengamma.strata.basics.date.PeriodAdditionConventions;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class PeriodAdjustment
implements Resolvable<DateAdjuster>,
ImmutableBean,
Serializable {
    public static final PeriodAdjustment NONE = new PeriodAdjustment(Period.ZERO, PeriodAdditionConventions.NONE, BusinessDayAdjustment.NONE);
    @PropertyDefinition(validate="notNull")
    private final Period period;
    @PropertyDefinition(validate="notNull")
    private final PeriodAdditionConvention additionConvention;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static PeriodAdjustment of(Period period, PeriodAdditionConvention additionConvention, BusinessDayAdjustment adjustment) {
        return new PeriodAdjustment(period, additionConvention, adjustment);
    }

    public static PeriodAdjustment ofLastDay(Period period, BusinessDayAdjustment adjustment) {
        return new PeriodAdjustment(period, PeriodAdditionConventions.LAST_DAY, adjustment);
    }

    public static PeriodAdjustment ofLastBusinessDay(Period period, BusinessDayAdjustment adjustment) {
        return new PeriodAdjustment(period, PeriodAdditionConventions.LAST_BUSINESS_DAY, adjustment);
    }

    private void validate() {
        if (this.additionConvention.isMonthBased() && this.period.getDays() != 0) {
            throw new IllegalArgumentException("Period must not contain days when addition convention is month-based");
        }
    }

    public LocalDate adjust(LocalDate date, ReferenceData refData) {
        HolidayCalendar holCal = this.adjustment.getCalendar().resolve(refData);
        BusinessDayConvention bda = this.adjustment.getConvention();
        return bda.adjust(this.additionConvention.adjust(date, this.period, holCal), holCal);
    }

    @Override
    public DateAdjuster resolve(ReferenceData refData) {
        HolidayCalendar holCal = this.adjustment.getCalendar().resolve(refData);
        BusinessDayConvention bda = this.adjustment.getConvention();
        return date -> bda.adjust(this.additionConvention.adjust(date, this.period, holCal), holCal);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.period);
        if (this.additionConvention != PeriodAdditionConventions.NONE) {
            buf.append(" with ").append(this.additionConvention);
        }
        if (!this.adjustment.equals(BusinessDayAdjustment.NONE)) {
            buf.append(" then apply ").append(this.adjustment);
        }
        return buf.toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private PeriodAdjustment(Period period, PeriodAdditionConvention additionConvention, BusinessDayAdjustment adjustment) {
        JodaBeanUtils.notNull((Object)period, (String)"period");
        JodaBeanUtils.notNull((Object)additionConvention, (String)"additionConvention");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.period = period;
        this.additionConvention = additionConvention;
        this.adjustment = adjustment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getPeriod() {
        return this.period;
    }

    public PeriodAdditionConvention getAdditionConvention() {
        return this.additionConvention;
    }

    public BusinessDayAdjustment getAdjustment() {
        return this.adjustment;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PeriodAdjustment other = (PeriodAdjustment)obj;
            return JodaBeanUtils.equal((Object)this.period, (Object)other.period) && JodaBeanUtils.equal((Object)this.additionConvention, (Object)other.additionConvention) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.period);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.additionConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<PeriodAdjustment> {
        private Period period;
        private PeriodAdditionConvention additionConvention;
        private BusinessDayAdjustment adjustment;

        private Builder() {
        }

        private Builder(PeriodAdjustment beanToCopy) {
            this.period = beanToCopy.getPeriod();
            this.additionConvention = beanToCopy.getAdditionConvention();
            this.adjustment = beanToCopy.getAdjustment();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return this.period;
                }
                case 1652975501: {
                    return this.additionConvention;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    this.period = (Period)newValue;
                    break;
                }
                case 1652975501: {
                    this.additionConvention = (PeriodAdditionConvention)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public PeriodAdjustment build() {
            return new PeriodAdjustment(this.period, this.additionConvention, this.adjustment);
        }

        public Builder period(Period period) {
            JodaBeanUtils.notNull((Object)period, (String)"period");
            this.period = period;
            return this;
        }

        public Builder additionConvention(PeriodAdditionConvention additionConvention) {
            JodaBeanUtils.notNull((Object)additionConvention, (String)"additionConvention");
            this.additionConvention = additionConvention;
            return this;
        }

        public Builder adjustment(BusinessDayAdjustment adjustment) {
            JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
            this.adjustment = adjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("PeriodAdjustment.Builder{");
            buf.append("period").append('=').append(JodaBeanUtils.toString((Object)this.period)).append(',').append(' ');
            buf.append("additionConvention").append('=').append(JodaBeanUtils.toString((Object)this.additionConvention)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> period = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"period", PeriodAdjustment.class, Period.class);
        private final MetaProperty<PeriodAdditionConvention> additionConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"additionConvention", PeriodAdjustment.class, PeriodAdditionConvention.class);
        private final MetaProperty<BusinessDayAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", PeriodAdjustment.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"period", "additionConvention", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return this.period;
                }
                case 1652975501: {
                    return this.additionConvention;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends PeriodAdjustment> beanType() {
            return PeriodAdjustment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> period() {
            return this.period;
        }

        public MetaProperty<PeriodAdditionConvention> additionConvention() {
            return this.additionConvention;
        }

        public MetaProperty<BusinessDayAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -991726143: {
                    return ((PeriodAdjustment)bean).getPeriod();
                }
                case 1652975501: {
                    return ((PeriodAdjustment)bean).getAdditionConvention();
                }
                case 1977085293: {
                    return ((PeriodAdjustment)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

