/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.location.Country;
import com.opengamma.strata.basics.schedule.Frequency;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutablePriceIndex
implements PriceIndex,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Country region;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final boolean active;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Frequency publicationFrequency;
    private static final long serialVersionUID = 1L;

    private static void applyDefaults(Builder builder) {
        builder.active = true;
    }

    @Override
    public FloatingRateName getFloatingRateName() {
        return FloatingRateName.of(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutablePriceIndex) {
            return this.name.equals(((ImmutablePriceIndex)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutablePriceIndex(String name, Country region, Currency currency, boolean active, Frequency publicationFrequency) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)region, (String)"region");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)publicationFrequency, (String)"publicationFrequency");
        this.name = name;
        this.region = region;
        this.currency = currency;
        this.active = active;
        this.publicationFrequency = publicationFrequency;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Country getRegion() {
        return this.region;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Frequency getPublicationFrequency() {
        return this.publicationFrequency;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutablePriceIndex> {
        private String name;
        private Country region;
        private Currency currency;
        private boolean active;
        private Frequency publicationFrequency;

        private Builder() {
            ImmutablePriceIndex.applyDefaults(this);
        }

        private Builder(ImmutablePriceIndex beanToCopy) {
            this.name = beanToCopy.getName();
            this.region = beanToCopy.getRegion();
            this.currency = beanToCopy.getCurrency();
            this.active = beanToCopy.isActive();
            this.publicationFrequency = beanToCopy.getPublicationFrequency();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -934795532: {
                    return this.region;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case -1407208304: {
                    return this.publicationFrequency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case -934795532: {
                    this.region = (Country)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -1422950650: {
                    this.active = (Boolean)newValue;
                    break;
                }
                case -1407208304: {
                    this.publicationFrequency = (Frequency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutablePriceIndex build() {
            return new ImmutablePriceIndex(this.name, this.region, this.currency, this.active, this.publicationFrequency);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder region(Country region) {
            JodaBeanUtils.notNull((Object)region, (String)"region");
            this.region = region;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder publicationFrequency(Frequency publicationFrequency) {
            JodaBeanUtils.notNull((Object)publicationFrequency, (String)"publicationFrequency");
            this.publicationFrequency = publicationFrequency;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutablePriceIndex.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("region").append('=').append(JodaBeanUtils.toString((Object)this.region)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("active").append('=').append(JodaBeanUtils.toString((Object)this.active)).append(',').append(' ');
            buf.append("publicationFrequency").append('=').append(JodaBeanUtils.toString((Object)this.publicationFrequency));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutablePriceIndex.class, String.class);
        private final MetaProperty<Country> region = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"region", ImmutablePriceIndex.class, Country.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutablePriceIndex.class, Currency.class);
        private final MetaProperty<Boolean> active = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"active", ImmutablePriceIndex.class, Boolean.TYPE);
        private final MetaProperty<Frequency> publicationFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"publicationFrequency", ImmutablePriceIndex.class, Frequency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "region", "currency", "active", "publicationFrequency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -934795532: {
                    return this.region;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case -1407208304: {
                    return this.publicationFrequency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutablePriceIndex> beanType() {
            return ImmutablePriceIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Country> region() {
            return this.region;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Boolean> active() {
            return this.active;
        }

        public MetaProperty<Frequency> publicationFrequency() {
            return this.publicationFrequency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutablePriceIndex)bean).getName();
                }
                case -934795532: {
                    return ((ImmutablePriceIndex)bean).getRegion();
                }
                case 575402001: {
                    return ((ImmutablePriceIndex)bean).getCurrency();
                }
                case -1422950650: {
                    return ((ImmutablePriceIndex)bean).isActive();
                }
                case -1407208304: {
                    return ((ImmutablePriceIndex)bean).getPublicationFrequency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

