/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.PeriodRange;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PeriodRangeAtLeastOneOf")
@ImplementedBy(value=Default.class)
public interface PeriodRangeAtLeastOneOf
extends Validator<PeriodRange> {
    public static final String NAME = "PeriodRangeAtLeastOneOf";
    public static final String DEFINITION = "lowerBound exists or upperBound exists";

    public static class NoOp
    implements PeriodRangeAtLeastOneOf {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PeriodRange periodRange) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PeriodRangeAtLeastOneOf {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PeriodRange periodRange) {
            ComparisonResult result = this.executeDataRule(periodRange);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PeriodRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PeriodRange", (RosettaPath)path, (String)PeriodRangeAtLeastOneOf.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PeriodRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PeriodRange", (RosettaPath)path, (String)PeriodRangeAtLeastOneOf.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PeriodRange periodRange) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)periodRange).map("getLowerBound", _periodRange -> _periodRange.getLowerBound())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)periodRange).map("getUpperBound", _periodRange -> _periodRange.getUpperBound())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

