/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=UpdateAmountDefault.class)
public abstract class UpdateAmount
implements RosettaFunction {
    public BigDecimal evaluate(BigDecimal oldAmount, BigDecimal changeAmount, QuantityChangeDirectionEnum direction) {
        BigDecimal newAmount = this.doEvaluate(oldAmount, changeAmount, direction);
        return newAmount;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, BigDecimal var2, QuantityChangeDirectionEnum var3);

    public static class UpdateAmountDefault
    extends UpdateAmount {
        @Override
        protected BigDecimal doEvaluate(BigDecimal oldAmount, BigDecimal changeAmount, QuantityChangeDirectionEnum direction) {
            BigDecimal newAmount = null;
            return this.assignOutput(newAmount, oldAmount, changeAmount, direction);
        }

        protected BigDecimal assignOutput(BigDecimal newAmount, BigDecimal oldAmount, BigDecimal changeAmount, QuantityChangeDirectionEnum direction) {
            newAmount = direction == null ? null : (direction == QuantityChangeDirectionEnum.INCREASE ? (BigDecimal)MapperMaths.add((Mapper)MapperS.of((Object)oldAmount), (Mapper)MapperS.of((Object)changeAmount)).get() : (direction == QuantityChangeDirectionEnum.DECREASE ? (BigDecimal)MapperMaths.subtract((Mapper)MapperS.of((Object)oldAmount), (Mapper)MapperS.of((Object)changeAmount)).get() : (direction == QuantityChangeDirectionEnum.REPLACE ? changeAmount : null)));
            return newAmount;
        }
    }
}

