/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Quantity;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.functions.FilterPrice;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.template.AssetPayout;
import cdm.product.template.metafields.ReferenceWithMetaAssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SecurityFinanceCashSettlementAmountDefault.class)
public abstract class SecurityFinanceCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FilterPrice filterPrice;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Transfer evaluate(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
        Transfer cashSettlementAmount;
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)quantity)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)quantity).map("getUnit", _quantity -> _quantity.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).map("getObservable", priceQuantity -> priceQuantity.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier.getValue()), (Mapper)this.assetPayout(tradeState, date, quantity, payerReceiver).map("getSecurityInformation", _assetPayout -> _assetPayout.getSecurityInformation()).map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), (CardinalityOperator)CardinalityOperator.All), "");
        Transfer.TransferBuilder cashSettlementAmountBuilder = this.doEvaluate(tradeState, date, quantity, payerReceiver);
        if (cashSettlementAmountBuilder == null) {
            cashSettlementAmount = null;
        } else {
            cashSettlementAmount = cashSettlementAmountBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)cashSettlementAmount);
        }
        return cashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract MapperS<? extends AssetPayout> assetPayout(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract MapperS<? extends Collateral> collateral(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract MapperS<? extends QuantitySchedule> securityQuantity(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract MapperS<? extends PriceSchedule> securityPrice(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    protected abstract MapperS<BigDecimal> marginRatio(TradeState var1, Date var2, Quantity var3, PayerReceiver var4);

    public static class SecurityFinanceCashSettlementAmountDefault
    extends SecurityFinanceCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            Transfer.TransferBuilder cashSettlementAmount = Transfer.builder();
            return this.assignOutput(cashSettlementAmount, tradeState, date, quantity, payerReceiver);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder cashSettlementAmount, TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            cashSettlementAmount.getOrCreateQuantity().setValue((BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)this.securityPrice(tradeState, date, quantity, payerReceiver).map("getValue", priceSchedule -> priceSchedule.getValue()), (Mapper)this.securityQuantity(tradeState, date, quantity, payerReceiver).map("getValue", quantitySchedule -> quantitySchedule.getValue())), this.marginRatio(tradeState, date, quantity, payerReceiver)).get());
            cashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrency((FieldWithMetaString)this.securityPrice(tradeState, date, quantity, payerReceiver).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            ReferenceWithMetaParty ifThenElseResult0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)payerReceiver)).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)payerReceiver).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : (ExpressionOperators.exists((Mapper)this.assetPayout(tradeState, date, quantity, payerReceiver).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.assetPayout(tradeState, date, quantity, payerReceiver).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : ReferenceWithMetaParty.builder().build());
            cashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReference(ifThenElseResult0);
            ReferenceWithMetaParty ifThenElseResult1 = ExpressionOperators.exists((Mapper)MapperS.of((Object)payerReceiver)).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)MapperS.of((Object)payerReceiver).map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : (ExpressionOperators.exists((Mapper)this.assetPayout(tradeState, date, quantity, payerReceiver).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getPayer", _payerReceiver -> _payerReceiver.getPayer())).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.assetPayout(tradeState, date, quantity, payerReceiver).map("getPayerReceiver", _assetPayout -> _assetPayout.getPayerReceiver()).map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get() : ReferenceWithMetaParty.builder().build());
            cashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReference(ifThenElseResult1);
            cashSettlementAmount.getOrCreateSettlementDate().setAdjustedDate(date == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(date).build());
            AssetPayout cashSettlementAmountSettlementOriginAssetPayout = (AssetPayout)this.assetPayout(tradeState, date, quantity, payerReceiver).get();
            cashSettlementAmount.getOrCreateSettlementOrigin().setAssetPayout(ReferenceWithMetaAssetPayout.builder().setGlobalReference(Optional.ofNullable(cashSettlementAmountSettlementOriginAssetPayout).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable(cashSettlementAmountSettlementOriginAssetPayout).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(cashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends AssetPayout> assetPayout(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)((AssetPayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral()).mapC("getCollateralPortfolio", _collateral -> _collateral.getCollateralPortfolio()).map("Type coercion", referenceWithMetaCollateralPortfolio -> referenceWithMetaCollateralPortfolio.getValue()).mapC("getCollateralPosition", collateralPortfolio -> collateralPortfolio.getCollateralPosition()).map("getProduct", collateralPosition -> collateralPosition.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getAssetPayout", payout -> payout.getAssetPayout()).get()));
        }

        @Override
        protected MapperS<? extends Collateral> collateral(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getCollateral", economicTerms -> economicTerms.getCollateral());
        }

        @Override
        protected MapperS<? extends QuantitySchedule> securityQuantity(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)quantity)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)quantity);
            }
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), FinancialUnitEnum.SHARE)).get()));
        }

        @Override
        protected MapperS<? extends PriceSchedule> securityPrice(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            return MapperS.of((Object)this.filterPrice.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti(), PriceTypeEnum.ASSET_PRICE, Collections.emptyList(), null));
        }

        @Override
        protected MapperS<BigDecimal> marginRatio(TradeState tradeState, Date date, Quantity quantity, PayerReceiver payerReceiver) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, date, quantity, payerReceiver).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.divide((Mapper)MapperS.of((Object)BigDecimal.valueOf(1L)), (Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)new BigDecimal("1.0")), (Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, date, quantity, payerReceiver).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getHaircutPercentage", collateralValuationTreatment -> collateralValuationTreatment.getHaircutPercentage())));
            }
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, date, quantity, payerReceiver).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((EligibleCollateralCriteria)this.collateral(tradeState, date, quantity, payerReceiver).map("getCollateralProvisions", _collateral -> _collateral.getCollateralProvisions()).mapC("getEligibleCollateral", collateralProvisions -> collateralProvisions.getEligibleCollateral()).get())).map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getValuationTreatment", collateralTreatment -> collateralTreatment.getValuationTreatment()).map("getMarginPercentage", collateralValuationTreatment -> collateralValuationTreatment.getMarginPercentage());
            }
            return MapperS.of((Object)new BigDecimal("1.0"));
        }
    }
}

