/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.event.common.Lineage;
import cdm.event.position.Position;
import cdm.event.position.meta.PortfolioStateMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PortfolioState", builder=PortfolioStateBuilderImpl.class, version="5.29.0")
@RuneDataType(value="PortfolioState", model="cdm", builder=PortfolioStateBuilderImpl.class, version="5.29.0")
public interface PortfolioState
extends RosettaModelObject,
GlobalKey {
    public static final PortfolioStateMeta metaData = new PortfolioStateMeta();

    public List<? extends Position> getPositions();

    public Lineage getLineage();

    public MetaFields getMeta();

    public PortfolioState build();

    public PortfolioStateBuilder toBuilder();

    public static PortfolioStateBuilder builder() {
        return new PortfolioStateBuilderImpl();
    }

    default public RosettaMetaData<? extends PortfolioState> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PortfolioState> getType() {
        return PortfolioState.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("positions"), processor, Position.class, this.getPositions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lineage"), processor, Lineage.class, this.getLineage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PortfolioStateBuilderImpl
    implements PortfolioStateBuilder {
        protected List<Position.PositionBuilder> positions = new ArrayList<Position.PositionBuilder>();
        protected Lineage.LineageBuilder lineage;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="positions")
        @RuneAttribute(value="positions")
        public List<? extends Position.PositionBuilder> getPositions() {
            return this.positions;
        }

        @Override
        public Position.PositionBuilder getOrCreatePositions(int index) {
            if (this.positions == null) {
                this.positions = new ArrayList<Position.PositionBuilder>();
            }
            return (Position.PositionBuilder)this.getIndex(this.positions, index, () -> {
                Position.PositionBuilder newPositions = Position.builder();
                return newPositions;
            });
        }

        @Override
        @RosettaAttribute(value="lineage", isRequired=true)
        @RuneAttribute(value="lineage", isRequired=true)
        public Lineage.LineageBuilder getLineage() {
            return this.lineage;
        }

        @Override
        public Lineage.LineageBuilder getOrCreateLineage() {
            Lineage.LineageBuilder result = this.lineage != null ? this.lineage : (this.lineage = Lineage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="positions")
        @RuneAttribute(value="positions")
        public PortfolioStateBuilder addPositions(Position _positions) {
            if (_positions != null) {
                this.positions.add(_positions.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioStateBuilder addPositions(Position _positions, int idx) {
            this.getIndex(this.positions, idx, () -> _positions.toBuilder());
            return this;
        }

        @Override
        public PortfolioStateBuilder addPositions(List<? extends Position> positionss) {
            if (positionss != null) {
                for (Position position : positionss) {
                    this.positions.add(position.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="positions")
        public PortfolioStateBuilder setPositions(List<? extends Position> positionss) {
            this.positions = positionss == null ? new ArrayList<Position.PositionBuilder>() : (List)positionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lineage", isRequired=true)
        @RuneAttribute(value="lineage", isRequired=true)
        public PortfolioStateBuilder setLineage(Lineage _lineage) {
            this.lineage = _lineage == null ? null : _lineage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PortfolioStateBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PortfolioState build() {
            return new PortfolioStateImpl(this);
        }

        @Override
        public PortfolioStateBuilder toBuilder() {
            return this;
        }

        @Override
        public PortfolioStateBuilder prune() {
            this.positions = this.positions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lineage != null && !this.lineage.prune().hasData()) {
                this.lineage = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPositions() != null && this.getPositions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLineage() != null && this.getLineage().hasData();
        }

        public PortfolioStateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PortfolioStateBuilder o = (PortfolioStateBuilder)other;
            merger.mergeRosetta(this.getPositions(), o.getPositions(), this::getOrCreatePositions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLineage(), (RosettaModelObjectBuilder)o.getLineage(), this::setLineage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioState _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.positions, _that.getPositions())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.positions != null ? this.positions.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioStateBuilder {positions=" + this.positions + ", lineage=" + this.lineage + ", meta=" + this.meta + '}';
        }
    }

    public static interface PortfolioStateBuilder
    extends PortfolioState,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public Position.PositionBuilder getOrCreatePositions(int var1);

        public List<? extends Position.PositionBuilder> getPositions();

        public Lineage.LineageBuilder getOrCreateLineage();

        @Override
        public Lineage.LineageBuilder getLineage();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PortfolioStateBuilder addPositions(Position var1);

        public PortfolioStateBuilder addPositions(Position var1, int var2);

        public PortfolioStateBuilder addPositions(List<? extends Position> var1);

        public PortfolioStateBuilder setPositions(List<? extends Position> var1);

        public PortfolioStateBuilder setLineage(Lineage var1);

        public PortfolioStateBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("positions"), processor, Position.PositionBuilder.class, this.getPositions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lineage"), processor, Lineage.LineageBuilder.class, this.getLineage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PortfolioStateBuilder prune();
    }

    public static class PortfolioStateImpl
    implements PortfolioState {
        private final List<? extends Position> positions;
        private final Lineage lineage;
        private final MetaFields meta;

        protected PortfolioStateImpl(PortfolioStateBuilder builder) {
            this.positions = Optional.ofNullable(builder.getPositions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lineage = Optional.ofNullable(builder.getLineage()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="positions")
        @RuneAttribute(value="positions")
        public List<? extends Position> getPositions() {
            return this.positions;
        }

        @Override
        @RosettaAttribute(value="lineage", isRequired=true)
        @RuneAttribute(value="lineage", isRequired=true)
        public Lineage getLineage() {
            return this.lineage;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PortfolioState build() {
            return this;
        }

        @Override
        public PortfolioStateBuilder toBuilder() {
            PortfolioStateBuilder builder = PortfolioState.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PortfolioStateBuilder builder) {
            Optional.ofNullable(this.getPositions()).ifPresent(builder::setPositions);
            Optional.ofNullable(this.getLineage()).ifPresent(builder::setLineage);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioState _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.positions, _that.getPositions())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.positions != null ? this.positions.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioState {positions=" + this.positions + ", lineage=" + this.lineage + ", meta=" + this.meta + '}';
        }
    }
}

