/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.functions.DetermineWeightingDates;
import cdm.observable.asset.calculatedrate.functions.GenerateWeights;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GenerateWeightingsDefault.class)
public abstract class GenerateWeightings
implements RosettaFunction {
    @Inject
    protected DetermineWeightingDates determineWeightingDates;
    @Inject
    protected GenerateWeights generateWeights;

    public List<BigDecimal> evaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
        List<BigDecimal> weights = this.doEvaluate(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        return weights;
    }

    protected abstract List<BigDecimal> doEvaluate(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperC<Date> weightingDates(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    public static class GenerateWeightingsDefault
    extends GenerateWeightings {
        @Override
        protected List<BigDecimal> doEvaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            if (observationDates == null) {
                observationDates = Collections.emptyList();
            }
            ArrayList<BigDecimal> weights = new ArrayList<BigDecimal>();
            return this.assignOutput(weights, calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> weights, FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            weights = this.generateWeights.evaluate(this.weightingDates(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti());
            return weights;
        }

        @Override
        protected MapperC<Date> weightingDates(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperC.of(this.determineWeightingDates.evaluate(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays));
        }
    }
}

