/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.fro.functions;

import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.fro.functions.IndexValueObservation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=IndexValueObservationMultipleDefault.class)
public abstract class IndexValueObservationMultiple
implements RosettaFunction {
    @Inject
    protected IndexValueObservation indexValueObservation;

    public List<BigDecimal> evaluate(List<Date> observationDate, FloatingRateOption floatingRateOption) {
        List<BigDecimal> observedValues = this.doEvaluate(observationDate, floatingRateOption);
        return observedValues;
    }

    protected abstract List<BigDecimal> doEvaluate(List<Date> var1, FloatingRateOption var2);

    public static class IndexValueObservationMultipleDefault
    extends IndexValueObservationMultiple {
        @Override
        protected List<BigDecimal> doEvaluate(List<Date> observationDate, FloatingRateOption floatingRateOption) {
            if (observationDate == null) {
                observationDate = Collections.emptyList();
            }
            ArrayList<BigDecimal> observedValues = new ArrayList<BigDecimal>();
            return this.assignOutput(observedValues, observationDate, floatingRateOption);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> observedValues, List<Date> observationDate, FloatingRateOption floatingRateOption) {
            observedValues.addAll(MapperC.of(observationDate).mapItem(item -> MapperS.of((Object)this.indexValueObservation.evaluate((Date)item.get(), floatingRateOption))).getMulti());
            return observedValues;
        }
    }
}

