/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.asset.Money;
import cdm.observable.event.CreditEventNotice;
import cdm.observable.event.FailureToPay;
import cdm.observable.event.Restructuring;
import cdm.observable.event.meta.CreditEventsMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CreditEvents", builder=CreditEventsBuilderImpl.class, version="5.29.0")
@RuneDataType(value="CreditEvents", model="cdm", builder=CreditEventsBuilderImpl.class, version="5.29.0")
public interface CreditEvents
extends RosettaModelObject,
GlobalKey {
    public static final CreditEventsMeta metaData = new CreditEventsMeta();

    public Boolean getBankruptcy();

    public FailureToPay getFailureToPay();

    public Boolean getFailureToPayPrincipal();

    public Boolean getFailureToPayInterest();

    public Boolean getObligationDefault();

    public Boolean getObligationAcceleration();

    public Boolean getRepudiationMoratorium();

    public Restructuring getRestructuring();

    public Boolean getGovernmentalIntervention();

    public Boolean getDistressedRatingsDowngrade();

    public Boolean getMaturityExtension();

    public Boolean getWritedown();

    public Boolean getImpliedWritedown();

    public Money getDefaultRequirement();

    public CreditEventNotice getCreditEventNotice();

    public MetaFields getMeta();

    public CreditEvents build();

    public CreditEventsBuilder toBuilder();

    public static CreditEventsBuilder builder() {
        return new CreditEventsBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditEvents> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditEvents> getType() {
        return CreditEvents.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("bankruptcy"), Boolean.class, (Object)this.getBankruptcy(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("failureToPay"), processor, FailureToPay.class, this.getFailureToPay(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("failureToPayPrincipal"), Boolean.class, (Object)this.getFailureToPayPrincipal(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("failureToPayInterest"), Boolean.class, (Object)this.getFailureToPayInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("obligationDefault"), Boolean.class, (Object)this.getObligationDefault(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("obligationAcceleration"), Boolean.class, (Object)this.getObligationAcceleration(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("repudiationMoratorium"), Boolean.class, (Object)this.getRepudiationMoratorium(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("restructuring"), processor, Restructuring.class, this.getRestructuring(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("governmentalIntervention"), Boolean.class, (Object)this.getGovernmentalIntervention(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("distressedRatingsDowngrade"), Boolean.class, (Object)this.getDistressedRatingsDowngrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityExtension"), Boolean.class, (Object)this.getMaturityExtension(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("writedown"), Boolean.class, (Object)this.getWritedown(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("impliedWritedown"), Boolean.class, (Object)this.getImpliedWritedown(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("defaultRequirement"), processor, Money.class, this.getDefaultRequirement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEventNotice"), processor, CreditEventNotice.class, this.getCreditEventNotice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class CreditEventsBuilderImpl
    implements CreditEventsBuilder {
        protected Boolean bankruptcy;
        protected FailureToPay.FailureToPayBuilder failureToPay;
        protected Boolean failureToPayPrincipal;
        protected Boolean failureToPayInterest;
        protected Boolean obligationDefault;
        protected Boolean obligationAcceleration;
        protected Boolean repudiationMoratorium;
        protected Restructuring.RestructuringBuilder restructuring;
        protected Boolean governmentalIntervention;
        protected Boolean distressedRatingsDowngrade;
        protected Boolean maturityExtension;
        protected Boolean writedown;
        protected Boolean impliedWritedown;
        protected Money.MoneyBuilder defaultRequirement;
        protected CreditEventNotice.CreditEventNoticeBuilder creditEventNotice;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="bankruptcy")
        @RuneAttribute(value="bankruptcy")
        public Boolean getBankruptcy() {
            return this.bankruptcy;
        }

        @Override
        @RosettaAttribute(value="failureToPay")
        @RuneAttribute(value="failureToPay")
        public FailureToPay.FailureToPayBuilder getFailureToPay() {
            return this.failureToPay;
        }

        @Override
        public FailureToPay.FailureToPayBuilder getOrCreateFailureToPay() {
            FailureToPay.FailureToPayBuilder result = this.failureToPay != null ? this.failureToPay : (this.failureToPay = FailureToPay.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="failureToPayPrincipal")
        @RuneAttribute(value="failureToPayPrincipal")
        public Boolean getFailureToPayPrincipal() {
            return this.failureToPayPrincipal;
        }

        @Override
        @RosettaAttribute(value="failureToPayInterest")
        @RuneAttribute(value="failureToPayInterest")
        public Boolean getFailureToPayInterest() {
            return this.failureToPayInterest;
        }

        @Override
        @RosettaAttribute(value="obligationDefault")
        @RuneAttribute(value="obligationDefault")
        public Boolean getObligationDefault() {
            return this.obligationDefault;
        }

        @Override
        @RosettaAttribute(value="obligationAcceleration")
        @RuneAttribute(value="obligationAcceleration")
        public Boolean getObligationAcceleration() {
            return this.obligationAcceleration;
        }

        @Override
        @RosettaAttribute(value="repudiationMoratorium")
        @RuneAttribute(value="repudiationMoratorium")
        public Boolean getRepudiationMoratorium() {
            return this.repudiationMoratorium;
        }

        @Override
        @RosettaAttribute(value="restructuring")
        @RuneAttribute(value="restructuring")
        public Restructuring.RestructuringBuilder getRestructuring() {
            return this.restructuring;
        }

        @Override
        public Restructuring.RestructuringBuilder getOrCreateRestructuring() {
            Restructuring.RestructuringBuilder result = this.restructuring != null ? this.restructuring : (this.restructuring = Restructuring.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="governmentalIntervention")
        @RuneAttribute(value="governmentalIntervention")
        public Boolean getGovernmentalIntervention() {
            return this.governmentalIntervention;
        }

        @Override
        @RosettaAttribute(value="distressedRatingsDowngrade")
        @RuneAttribute(value="distressedRatingsDowngrade")
        public Boolean getDistressedRatingsDowngrade() {
            return this.distressedRatingsDowngrade;
        }

        @Override
        @RosettaAttribute(value="maturityExtension")
        @RuneAttribute(value="maturityExtension")
        public Boolean getMaturityExtension() {
            return this.maturityExtension;
        }

        @Override
        @RosettaAttribute(value="writedown")
        @RuneAttribute(value="writedown")
        public Boolean getWritedown() {
            return this.writedown;
        }

        @Override
        @RosettaAttribute(value="impliedWritedown")
        @RuneAttribute(value="impliedWritedown")
        public Boolean getImpliedWritedown() {
            return this.impliedWritedown;
        }

        @Override
        @RosettaAttribute(value="defaultRequirement")
        @RuneAttribute(value="defaultRequirement")
        public Money.MoneyBuilder getDefaultRequirement() {
            return this.defaultRequirement;
        }

        @Override
        public Money.MoneyBuilder getOrCreateDefaultRequirement() {
            Money.MoneyBuilder result = this.defaultRequirement != null ? this.defaultRequirement : (this.defaultRequirement = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventNotice.CreditEventNoticeBuilder getCreditEventNotice() {
            return this.creditEventNotice;
        }

        @Override
        public CreditEventNotice.CreditEventNoticeBuilder getOrCreateCreditEventNotice() {
            CreditEventNotice.CreditEventNoticeBuilder result = this.creditEventNotice != null ? this.creditEventNotice : (this.creditEventNotice = CreditEventNotice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bankruptcy")
        @RuneAttribute(value="bankruptcy")
        public CreditEventsBuilder setBankruptcy(Boolean _bankruptcy) {
            this.bankruptcy = _bankruptcy == null ? null : _bankruptcy;
            return this;
        }

        @Override
        @RosettaAttribute(value="failureToPay")
        @RuneAttribute(value="failureToPay")
        public CreditEventsBuilder setFailureToPay(FailureToPay _failureToPay) {
            this.failureToPay = _failureToPay == null ? null : _failureToPay.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="failureToPayPrincipal")
        @RuneAttribute(value="failureToPayPrincipal")
        public CreditEventsBuilder setFailureToPayPrincipal(Boolean _failureToPayPrincipal) {
            this.failureToPayPrincipal = _failureToPayPrincipal == null ? null : _failureToPayPrincipal;
            return this;
        }

        @Override
        @RosettaAttribute(value="failureToPayInterest")
        @RuneAttribute(value="failureToPayInterest")
        public CreditEventsBuilder setFailureToPayInterest(Boolean _failureToPayInterest) {
            this.failureToPayInterest = _failureToPayInterest == null ? null : _failureToPayInterest;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligationDefault")
        @RuneAttribute(value="obligationDefault")
        public CreditEventsBuilder setObligationDefault(Boolean _obligationDefault) {
            this.obligationDefault = _obligationDefault == null ? null : _obligationDefault;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligationAcceleration")
        @RuneAttribute(value="obligationAcceleration")
        public CreditEventsBuilder setObligationAcceleration(Boolean _obligationAcceleration) {
            this.obligationAcceleration = _obligationAcceleration == null ? null : _obligationAcceleration;
            return this;
        }

        @Override
        @RosettaAttribute(value="repudiationMoratorium")
        @RuneAttribute(value="repudiationMoratorium")
        public CreditEventsBuilder setRepudiationMoratorium(Boolean _repudiationMoratorium) {
            this.repudiationMoratorium = _repudiationMoratorium == null ? null : _repudiationMoratorium;
            return this;
        }

        @Override
        @RosettaAttribute(value="restructuring")
        @RuneAttribute(value="restructuring")
        public CreditEventsBuilder setRestructuring(Restructuring _restructuring) {
            this.restructuring = _restructuring == null ? null : _restructuring.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="governmentalIntervention")
        @RuneAttribute(value="governmentalIntervention")
        public CreditEventsBuilder setGovernmentalIntervention(Boolean _governmentalIntervention) {
            this.governmentalIntervention = _governmentalIntervention == null ? null : _governmentalIntervention;
            return this;
        }

        @Override
        @RosettaAttribute(value="distressedRatingsDowngrade")
        @RuneAttribute(value="distressedRatingsDowngrade")
        public CreditEventsBuilder setDistressedRatingsDowngrade(Boolean _distressedRatingsDowngrade) {
            this.distressedRatingsDowngrade = _distressedRatingsDowngrade == null ? null : _distressedRatingsDowngrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityExtension")
        @RuneAttribute(value="maturityExtension")
        public CreditEventsBuilder setMaturityExtension(Boolean _maturityExtension) {
            this.maturityExtension = _maturityExtension == null ? null : _maturityExtension;
            return this;
        }

        @Override
        @RosettaAttribute(value="writedown")
        @RuneAttribute(value="writedown")
        public CreditEventsBuilder setWritedown(Boolean _writedown) {
            this.writedown = _writedown == null ? null : _writedown;
            return this;
        }

        @Override
        @RosettaAttribute(value="impliedWritedown")
        @RuneAttribute(value="impliedWritedown")
        public CreditEventsBuilder setImpliedWritedown(Boolean _impliedWritedown) {
            this.impliedWritedown = _impliedWritedown == null ? null : _impliedWritedown;
            return this;
        }

        @Override
        @RosettaAttribute(value="defaultRequirement")
        @RuneAttribute(value="defaultRequirement")
        public CreditEventsBuilder setDefaultRequirement(Money _defaultRequirement) {
            this.defaultRequirement = _defaultRequirement == null ? null : _defaultRequirement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventsBuilder setCreditEventNotice(CreditEventNotice _creditEventNotice) {
            this.creditEventNotice = _creditEventNotice == null ? null : _creditEventNotice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public CreditEventsBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public CreditEvents build() {
            return new CreditEventsImpl(this);
        }

        @Override
        public CreditEventsBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventsBuilder prune() {
            if (this.failureToPay != null && !this.failureToPay.prune().hasData()) {
                this.failureToPay = null;
            }
            if (this.restructuring != null && !this.restructuring.prune().hasData()) {
                this.restructuring = null;
            }
            if (this.defaultRequirement != null && !this.defaultRequirement.prune().hasData()) {
                this.defaultRequirement = null;
            }
            if (this.creditEventNotice != null && !this.creditEventNotice.prune().hasData()) {
                this.creditEventNotice = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBankruptcy() != null) {
                return true;
            }
            if (this.getFailureToPay() != null && this.getFailureToPay().hasData()) {
                return true;
            }
            if (this.getFailureToPayPrincipal() != null) {
                return true;
            }
            if (this.getFailureToPayInterest() != null) {
                return true;
            }
            if (this.getObligationDefault() != null) {
                return true;
            }
            if (this.getObligationAcceleration() != null) {
                return true;
            }
            if (this.getRepudiationMoratorium() != null) {
                return true;
            }
            if (this.getRestructuring() != null && this.getRestructuring().hasData()) {
                return true;
            }
            if (this.getGovernmentalIntervention() != null) {
                return true;
            }
            if (this.getDistressedRatingsDowngrade() != null) {
                return true;
            }
            if (this.getMaturityExtension() != null) {
                return true;
            }
            if (this.getWritedown() != null) {
                return true;
            }
            if (this.getImpliedWritedown() != null) {
                return true;
            }
            if (this.getDefaultRequirement() != null && this.getDefaultRequirement().hasData()) {
                return true;
            }
            return this.getCreditEventNotice() != null && this.getCreditEventNotice().hasData();
        }

        public CreditEventsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventsBuilder o = (CreditEventsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFailureToPay(), (RosettaModelObjectBuilder)o.getFailureToPay(), this::setFailureToPay);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRestructuring(), (RosettaModelObjectBuilder)o.getRestructuring(), this::setRestructuring);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDefaultRequirement(), (RosettaModelObjectBuilder)o.getDefaultRequirement(), this::setDefaultRequirement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEventNotice(), (RosettaModelObjectBuilder)o.getCreditEventNotice(), this::setCreditEventNotice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getBankruptcy(), (Object)o.getBankruptcy(), this::setBankruptcy, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFailureToPayPrincipal(), (Object)o.getFailureToPayPrincipal(), this::setFailureToPayPrincipal, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFailureToPayInterest(), (Object)o.getFailureToPayInterest(), this::setFailureToPayInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObligationDefault(), (Object)o.getObligationDefault(), this::setObligationDefault, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObligationAcceleration(), (Object)o.getObligationAcceleration(), this::setObligationAcceleration, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRepudiationMoratorium(), (Object)o.getRepudiationMoratorium(), this::setRepudiationMoratorium, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGovernmentalIntervention(), (Object)o.getGovernmentalIntervention(), this::setGovernmentalIntervention, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDistressedRatingsDowngrade(), (Object)o.getDistressedRatingsDowngrade(), this::setDistressedRatingsDowngrade, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityExtension(), (Object)o.getMaturityExtension(), this::setMaturityExtension, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWritedown(), (Object)o.getWritedown(), this::setWritedown, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getImpliedWritedown(), (Object)o.getImpliedWritedown(), this::setImpliedWritedown, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvents _that = this.getType().cast(o);
            if (!Objects.equals(this.bankruptcy, _that.getBankruptcy())) {
                return false;
            }
            if (!Objects.equals(this.failureToPay, _that.getFailureToPay())) {
                return false;
            }
            if (!Objects.equals(this.failureToPayPrincipal, _that.getFailureToPayPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.failureToPayInterest, _that.getFailureToPayInterest())) {
                return false;
            }
            if (!Objects.equals(this.obligationDefault, _that.getObligationDefault())) {
                return false;
            }
            if (!Objects.equals(this.obligationAcceleration, _that.getObligationAcceleration())) {
                return false;
            }
            if (!Objects.equals(this.repudiationMoratorium, _that.getRepudiationMoratorium())) {
                return false;
            }
            if (!Objects.equals(this.restructuring, _that.getRestructuring())) {
                return false;
            }
            if (!Objects.equals(this.governmentalIntervention, _that.getGovernmentalIntervention())) {
                return false;
            }
            if (!Objects.equals(this.distressedRatingsDowngrade, _that.getDistressedRatingsDowngrade())) {
                return false;
            }
            if (!Objects.equals(this.maturityExtension, _that.getMaturityExtension())) {
                return false;
            }
            if (!Objects.equals(this.writedown, _that.getWritedown())) {
                return false;
            }
            if (!Objects.equals(this.impliedWritedown, _that.getImpliedWritedown())) {
                return false;
            }
            if (!Objects.equals(this.defaultRequirement, _that.getDefaultRequirement())) {
                return false;
            }
            if (!Objects.equals(this.creditEventNotice, _that.getCreditEventNotice())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bankruptcy != null ? this.bankruptcy.hashCode() : 0);
            _result = 31 * _result + (this.failureToPay != null ? this.failureToPay.hashCode() : 0);
            _result = 31 * _result + (this.failureToPayPrincipal != null ? this.failureToPayPrincipal.hashCode() : 0);
            _result = 31 * _result + (this.failureToPayInterest != null ? this.failureToPayInterest.hashCode() : 0);
            _result = 31 * _result + (this.obligationDefault != null ? this.obligationDefault.hashCode() : 0);
            _result = 31 * _result + (this.obligationAcceleration != null ? this.obligationAcceleration.hashCode() : 0);
            _result = 31 * _result + (this.repudiationMoratorium != null ? this.repudiationMoratorium.hashCode() : 0);
            _result = 31 * _result + (this.restructuring != null ? this.restructuring.hashCode() : 0);
            _result = 31 * _result + (this.governmentalIntervention != null ? this.governmentalIntervention.hashCode() : 0);
            _result = 31 * _result + (this.distressedRatingsDowngrade != null ? this.distressedRatingsDowngrade.hashCode() : 0);
            _result = 31 * _result + (this.maturityExtension != null ? this.maturityExtension.hashCode() : 0);
            _result = 31 * _result + (this.writedown != null ? this.writedown.hashCode() : 0);
            _result = 31 * _result + (this.impliedWritedown != null ? this.impliedWritedown.hashCode() : 0);
            _result = 31 * _result + (this.defaultRequirement != null ? this.defaultRequirement.hashCode() : 0);
            _result = 31 * _result + (this.creditEventNotice != null ? this.creditEventNotice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventsBuilder {bankruptcy=" + this.bankruptcy + ", failureToPay=" + this.failureToPay + ", failureToPayPrincipal=" + this.failureToPayPrincipal + ", failureToPayInterest=" + this.failureToPayInterest + ", obligationDefault=" + this.obligationDefault + ", obligationAcceleration=" + this.obligationAcceleration + ", repudiationMoratorium=" + this.repudiationMoratorium + ", restructuring=" + this.restructuring + ", governmentalIntervention=" + this.governmentalIntervention + ", distressedRatingsDowngrade=" + this.distressedRatingsDowngrade + ", maturityExtension=" + this.maturityExtension + ", writedown=" + this.writedown + ", impliedWritedown=" + this.impliedWritedown + ", defaultRequirement=" + this.defaultRequirement + ", creditEventNotice=" + this.creditEventNotice + ", meta=" + this.meta + '}';
        }
    }

    public static interface CreditEventsBuilder
    extends CreditEvents,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public FailureToPay.FailureToPayBuilder getOrCreateFailureToPay();

        @Override
        public FailureToPay.FailureToPayBuilder getFailureToPay();

        public Restructuring.RestructuringBuilder getOrCreateRestructuring();

        @Override
        public Restructuring.RestructuringBuilder getRestructuring();

        public Money.MoneyBuilder getOrCreateDefaultRequirement();

        @Override
        public Money.MoneyBuilder getDefaultRequirement();

        public CreditEventNotice.CreditEventNoticeBuilder getOrCreateCreditEventNotice();

        @Override
        public CreditEventNotice.CreditEventNoticeBuilder getCreditEventNotice();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public CreditEventsBuilder setBankruptcy(Boolean var1);

        public CreditEventsBuilder setFailureToPay(FailureToPay var1);

        public CreditEventsBuilder setFailureToPayPrincipal(Boolean var1);

        public CreditEventsBuilder setFailureToPayInterest(Boolean var1);

        public CreditEventsBuilder setObligationDefault(Boolean var1);

        public CreditEventsBuilder setObligationAcceleration(Boolean var1);

        public CreditEventsBuilder setRepudiationMoratorium(Boolean var1);

        public CreditEventsBuilder setRestructuring(Restructuring var1);

        public CreditEventsBuilder setGovernmentalIntervention(Boolean var1);

        public CreditEventsBuilder setDistressedRatingsDowngrade(Boolean var1);

        public CreditEventsBuilder setMaturityExtension(Boolean var1);

        public CreditEventsBuilder setWritedown(Boolean var1);

        public CreditEventsBuilder setImpliedWritedown(Boolean var1);

        public CreditEventsBuilder setDefaultRequirement(Money var1);

        public CreditEventsBuilder setCreditEventNotice(CreditEventNotice var1);

        public CreditEventsBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("bankruptcy"), Boolean.class, (Object)this.getBankruptcy(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("failureToPay"), processor, FailureToPay.FailureToPayBuilder.class, this.getFailureToPay(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("failureToPayPrincipal"), Boolean.class, (Object)this.getFailureToPayPrincipal(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("failureToPayInterest"), Boolean.class, (Object)this.getFailureToPayInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("obligationDefault"), Boolean.class, (Object)this.getObligationDefault(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("obligationAcceleration"), Boolean.class, (Object)this.getObligationAcceleration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("repudiationMoratorium"), Boolean.class, (Object)this.getRepudiationMoratorium(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("restructuring"), processor, Restructuring.RestructuringBuilder.class, this.getRestructuring(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("governmentalIntervention"), Boolean.class, (Object)this.getGovernmentalIntervention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("distressedRatingsDowngrade"), Boolean.class, (Object)this.getDistressedRatingsDowngrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityExtension"), Boolean.class, (Object)this.getMaturityExtension(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("writedown"), Boolean.class, (Object)this.getWritedown(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("impliedWritedown"), Boolean.class, (Object)this.getImpliedWritedown(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("defaultRequirement"), processor, Money.MoneyBuilder.class, this.getDefaultRequirement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEventNotice"), processor, CreditEventNotice.CreditEventNoticeBuilder.class, this.getCreditEventNotice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public CreditEventsBuilder prune();
    }

    public static class CreditEventsImpl
    implements CreditEvents {
        private final Boolean bankruptcy;
        private final FailureToPay failureToPay;
        private final Boolean failureToPayPrincipal;
        private final Boolean failureToPayInterest;
        private final Boolean obligationDefault;
        private final Boolean obligationAcceleration;
        private final Boolean repudiationMoratorium;
        private final Restructuring restructuring;
        private final Boolean governmentalIntervention;
        private final Boolean distressedRatingsDowngrade;
        private final Boolean maturityExtension;
        private final Boolean writedown;
        private final Boolean impliedWritedown;
        private final Money defaultRequirement;
        private final CreditEventNotice creditEventNotice;
        private final MetaFields meta;

        protected CreditEventsImpl(CreditEventsBuilder builder) {
            this.bankruptcy = builder.getBankruptcy();
            this.failureToPay = Optional.ofNullable(builder.getFailureToPay()).map(f -> f.build()).orElse(null);
            this.failureToPayPrincipal = builder.getFailureToPayPrincipal();
            this.failureToPayInterest = builder.getFailureToPayInterest();
            this.obligationDefault = builder.getObligationDefault();
            this.obligationAcceleration = builder.getObligationAcceleration();
            this.repudiationMoratorium = builder.getRepudiationMoratorium();
            this.restructuring = Optional.ofNullable(builder.getRestructuring()).map(f -> f.build()).orElse(null);
            this.governmentalIntervention = builder.getGovernmentalIntervention();
            this.distressedRatingsDowngrade = builder.getDistressedRatingsDowngrade();
            this.maturityExtension = builder.getMaturityExtension();
            this.writedown = builder.getWritedown();
            this.impliedWritedown = builder.getImpliedWritedown();
            this.defaultRequirement = Optional.ofNullable(builder.getDefaultRequirement()).map(f -> f.build()).orElse(null);
            this.creditEventNotice = Optional.ofNullable(builder.getCreditEventNotice()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="bankruptcy")
        @RuneAttribute(value="bankruptcy")
        public Boolean getBankruptcy() {
            return this.bankruptcy;
        }

        @Override
        @RosettaAttribute(value="failureToPay")
        @RuneAttribute(value="failureToPay")
        public FailureToPay getFailureToPay() {
            return this.failureToPay;
        }

        @Override
        @RosettaAttribute(value="failureToPayPrincipal")
        @RuneAttribute(value="failureToPayPrincipal")
        public Boolean getFailureToPayPrincipal() {
            return this.failureToPayPrincipal;
        }

        @Override
        @RosettaAttribute(value="failureToPayInterest")
        @RuneAttribute(value="failureToPayInterest")
        public Boolean getFailureToPayInterest() {
            return this.failureToPayInterest;
        }

        @Override
        @RosettaAttribute(value="obligationDefault")
        @RuneAttribute(value="obligationDefault")
        public Boolean getObligationDefault() {
            return this.obligationDefault;
        }

        @Override
        @RosettaAttribute(value="obligationAcceleration")
        @RuneAttribute(value="obligationAcceleration")
        public Boolean getObligationAcceleration() {
            return this.obligationAcceleration;
        }

        @Override
        @RosettaAttribute(value="repudiationMoratorium")
        @RuneAttribute(value="repudiationMoratorium")
        public Boolean getRepudiationMoratorium() {
            return this.repudiationMoratorium;
        }

        @Override
        @RosettaAttribute(value="restructuring")
        @RuneAttribute(value="restructuring")
        public Restructuring getRestructuring() {
            return this.restructuring;
        }

        @Override
        @RosettaAttribute(value="governmentalIntervention")
        @RuneAttribute(value="governmentalIntervention")
        public Boolean getGovernmentalIntervention() {
            return this.governmentalIntervention;
        }

        @Override
        @RosettaAttribute(value="distressedRatingsDowngrade")
        @RuneAttribute(value="distressedRatingsDowngrade")
        public Boolean getDistressedRatingsDowngrade() {
            return this.distressedRatingsDowngrade;
        }

        @Override
        @RosettaAttribute(value="maturityExtension")
        @RuneAttribute(value="maturityExtension")
        public Boolean getMaturityExtension() {
            return this.maturityExtension;
        }

        @Override
        @RosettaAttribute(value="writedown")
        @RuneAttribute(value="writedown")
        public Boolean getWritedown() {
            return this.writedown;
        }

        @Override
        @RosettaAttribute(value="impliedWritedown")
        @RuneAttribute(value="impliedWritedown")
        public Boolean getImpliedWritedown() {
            return this.impliedWritedown;
        }

        @Override
        @RosettaAttribute(value="defaultRequirement")
        @RuneAttribute(value="defaultRequirement")
        public Money getDefaultRequirement() {
            return this.defaultRequirement;
        }

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventNotice getCreditEventNotice() {
            return this.creditEventNotice;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public CreditEvents build() {
            return this;
        }

        @Override
        public CreditEventsBuilder toBuilder() {
            CreditEventsBuilder builder = CreditEvents.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventsBuilder builder) {
            Optional.ofNullable(this.getBankruptcy()).ifPresent(builder::setBankruptcy);
            Optional.ofNullable(this.getFailureToPay()).ifPresent(builder::setFailureToPay);
            Optional.ofNullable(this.getFailureToPayPrincipal()).ifPresent(builder::setFailureToPayPrincipal);
            Optional.ofNullable(this.getFailureToPayInterest()).ifPresent(builder::setFailureToPayInterest);
            Optional.ofNullable(this.getObligationDefault()).ifPresent(builder::setObligationDefault);
            Optional.ofNullable(this.getObligationAcceleration()).ifPresent(builder::setObligationAcceleration);
            Optional.ofNullable(this.getRepudiationMoratorium()).ifPresent(builder::setRepudiationMoratorium);
            Optional.ofNullable(this.getRestructuring()).ifPresent(builder::setRestructuring);
            Optional.ofNullable(this.getGovernmentalIntervention()).ifPresent(builder::setGovernmentalIntervention);
            Optional.ofNullable(this.getDistressedRatingsDowngrade()).ifPresent(builder::setDistressedRatingsDowngrade);
            Optional.ofNullable(this.getMaturityExtension()).ifPresent(builder::setMaturityExtension);
            Optional.ofNullable(this.getWritedown()).ifPresent(builder::setWritedown);
            Optional.ofNullable(this.getImpliedWritedown()).ifPresent(builder::setImpliedWritedown);
            Optional.ofNullable(this.getDefaultRequirement()).ifPresent(builder::setDefaultRequirement);
            Optional.ofNullable(this.getCreditEventNotice()).ifPresent(builder::setCreditEventNotice);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvents _that = this.getType().cast(o);
            if (!Objects.equals(this.bankruptcy, _that.getBankruptcy())) {
                return false;
            }
            if (!Objects.equals(this.failureToPay, _that.getFailureToPay())) {
                return false;
            }
            if (!Objects.equals(this.failureToPayPrincipal, _that.getFailureToPayPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.failureToPayInterest, _that.getFailureToPayInterest())) {
                return false;
            }
            if (!Objects.equals(this.obligationDefault, _that.getObligationDefault())) {
                return false;
            }
            if (!Objects.equals(this.obligationAcceleration, _that.getObligationAcceleration())) {
                return false;
            }
            if (!Objects.equals(this.repudiationMoratorium, _that.getRepudiationMoratorium())) {
                return false;
            }
            if (!Objects.equals(this.restructuring, _that.getRestructuring())) {
                return false;
            }
            if (!Objects.equals(this.governmentalIntervention, _that.getGovernmentalIntervention())) {
                return false;
            }
            if (!Objects.equals(this.distressedRatingsDowngrade, _that.getDistressedRatingsDowngrade())) {
                return false;
            }
            if (!Objects.equals(this.maturityExtension, _that.getMaturityExtension())) {
                return false;
            }
            if (!Objects.equals(this.writedown, _that.getWritedown())) {
                return false;
            }
            if (!Objects.equals(this.impliedWritedown, _that.getImpliedWritedown())) {
                return false;
            }
            if (!Objects.equals(this.defaultRequirement, _that.getDefaultRequirement())) {
                return false;
            }
            if (!Objects.equals(this.creditEventNotice, _that.getCreditEventNotice())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bankruptcy != null ? this.bankruptcy.hashCode() : 0);
            _result = 31 * _result + (this.failureToPay != null ? this.failureToPay.hashCode() : 0);
            _result = 31 * _result + (this.failureToPayPrincipal != null ? this.failureToPayPrincipal.hashCode() : 0);
            _result = 31 * _result + (this.failureToPayInterest != null ? this.failureToPayInterest.hashCode() : 0);
            _result = 31 * _result + (this.obligationDefault != null ? this.obligationDefault.hashCode() : 0);
            _result = 31 * _result + (this.obligationAcceleration != null ? this.obligationAcceleration.hashCode() : 0);
            _result = 31 * _result + (this.repudiationMoratorium != null ? this.repudiationMoratorium.hashCode() : 0);
            _result = 31 * _result + (this.restructuring != null ? this.restructuring.hashCode() : 0);
            _result = 31 * _result + (this.governmentalIntervention != null ? this.governmentalIntervention.hashCode() : 0);
            _result = 31 * _result + (this.distressedRatingsDowngrade != null ? this.distressedRatingsDowngrade.hashCode() : 0);
            _result = 31 * _result + (this.maturityExtension != null ? this.maturityExtension.hashCode() : 0);
            _result = 31 * _result + (this.writedown != null ? this.writedown.hashCode() : 0);
            _result = 31 * _result + (this.impliedWritedown != null ? this.impliedWritedown.hashCode() : 0);
            _result = 31 * _result + (this.defaultRequirement != null ? this.defaultRequirement.hashCode() : 0);
            _result = 31 * _result + (this.creditEventNotice != null ? this.creditEventNotice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEvents {bankruptcy=" + this.bankruptcy + ", failureToPay=" + this.failureToPay + ", failureToPayPrincipal=" + this.failureToPayPrincipal + ", failureToPayInterest=" + this.failureToPayInterest + ", obligationDefault=" + this.obligationDefault + ", obligationAcceleration=" + this.obligationAcceleration + ", repudiationMoratorium=" + this.repudiationMoratorium + ", restructuring=" + this.restructuring + ", governmentalIntervention=" + this.governmentalIntervention + ", distressedRatingsDowngrade=" + this.distressedRatingsDowngrade + ", maturityExtension=" + this.maturityExtension + ", writedown=" + this.writedown + ", impliedWritedown=" + this.impliedWritedown + ", defaultRequirement=" + this.defaultRequirement + ", creditEventNotice=" + this.creditEventNotice + ", meta=" + this.meta + '}';
        }
    }
}

