/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.Offset;
import cdm.base.math.AveragingWeightingMethodEnum;
import cdm.base.math.Rounding;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.InterpolationMethodEnum;
import cdm.observable.asset.Price;
import cdm.observable.asset.calculatedrate.FallbackRateParameters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.InflationCalculationMethodEnum;
import cdm.observable.asset.calculatedrate.InflationCalculationStyleEnum;
import cdm.observable.asset.metafields.FieldWithMetaInterpolationMethodEnum;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FinalPrincipalExchangeCalculationEnum;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.InflationRateSpecificationMeta;
import cdm.product.common.schedule.RateSchedule;
import cdm.product.template.StrikeSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InflationRateSpecification", builder=InflationRateSpecificationBuilderImpl.class, version="5.29.0")
@RuneDataType(value="InflationRateSpecification", model="cdm", builder=InflationRateSpecificationBuilderImpl.class, version="5.29.0")
public interface InflationRateSpecification
extends FloatingRateSpecification {
    public static final InflationRateSpecificationMeta metaData = new InflationRateSpecificationMeta();

    public Offset getInflationLag();

    public FieldWithMetaString getIndexSource();

    public FieldWithMetaString getMainPublication();

    public FieldWithMetaInterpolationMethodEnum getInterpolationMethod();

    public BigDecimal getInitialIndexLevel();

    public Boolean getFallbackBondApplicable();

    public InflationCalculationMethodEnum getCalculationMethod();

    public InflationCalculationStyleEnum getCalculationStyle();

    public FinalPrincipalExchangeCalculationEnum getFinalPrincipalExchangeCalculation();

    @Override
    public InflationRateSpecification build();

    @Override
    public InflationRateSpecificationBuilder toBuilder();

    public static InflationRateSpecificationBuilder builder() {
        return new InflationRateSpecificationBuilderImpl();
    }

    default public RosettaMetaData<? extends InflationRateSpecification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InflationRateSpecification> getType() {
        return InflationRateSpecification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("rateOption"), processor, ReferenceWithMetaFloatingRateOption.class, this.getRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.class, this.getCapRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.class, this.getCalculationParameters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.class, this.getFallbackRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialRate"), processor, Price.class, this.getInitialRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.class, this.getFinalRateRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inflationLag"), processor, Offset.class, this.getInflationLag(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexSource"), processor, FieldWithMetaString.class, this.getIndexSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("mainPublication"), processor, FieldWithMetaString.class, this.getMainPublication(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interpolationMethod"), processor, FieldWithMetaInterpolationMethodEnum.class, this.getInterpolationMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialIndexLevel"), BigDecimal.class, (Object)this.getInitialIndexLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fallbackBondApplicable"), Boolean.class, (Object)this.getFallbackBondApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationMethod"), InflationCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationStyle"), InflationCalculationStyleEnum.class, (Object)this.getCalculationStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalPrincipalExchangeCalculation"), FinalPrincipalExchangeCalculationEnum.class, (Object)this.getFinalPrincipalExchangeCalculation(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class InflationRateSpecificationBuilderImpl
    extends FloatingRateSpecification.FloatingRateSpecificationBuilderImpl
    implements InflationRateSpecificationBuilder {
        protected Offset.OffsetBuilder inflationLag;
        protected FieldWithMetaString.FieldWithMetaStringBuilder indexSource;
        protected FieldWithMetaString.FieldWithMetaStringBuilder mainPublication;
        protected FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder interpolationMethod;
        protected BigDecimal initialIndexLevel;
        protected Boolean fallbackBondApplicable;
        protected InflationCalculationMethodEnum calculationMethod;
        protected InflationCalculationStyleEnum calculationStyle;
        protected FinalPrincipalExchangeCalculationEnum finalPrincipalExchangeCalculation;

        @Override
        @RosettaAttribute(value="inflationLag", isRequired=true)
        @RuneAttribute(value="inflationLag", isRequired=true)
        public Offset.OffsetBuilder getInflationLag() {
            return this.inflationLag;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateInflationLag() {
            Offset.OffsetBuilder result = this.inflationLag != null ? this.inflationLag : (this.inflationLag = Offset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexSource", isRequired=true)
        @RuneAttribute(value="indexSource", isRequired=true)
        public FieldWithMetaString.FieldWithMetaStringBuilder getIndexSource() {
            return this.indexSource;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIndexSource() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.indexSource != null ? this.indexSource : (this.indexSource = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mainPublication", isRequired=true)
        @RuneAttribute(value="mainPublication", isRequired=true)
        public FieldWithMetaString.FieldWithMetaStringBuilder getMainPublication() {
            return this.mainPublication;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateMainPublication() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.mainPublication != null ? this.mainPublication : (this.mainPublication = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interpolationMethod", isRequired=true)
        @RuneAttribute(value="interpolationMethod", isRequired=true)
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getOrCreateInterpolationMethod() {
            FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder result = this.interpolationMethod != null ? this.interpolationMethod : (this.interpolationMethod = FieldWithMetaInterpolationMethodEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialIndexLevel")
        @RuneAttribute(value="initialIndexLevel")
        public BigDecimal getInitialIndexLevel() {
            return this.initialIndexLevel;
        }

        @Override
        @RosettaAttribute(value="fallbackBondApplicable", isRequired=true)
        @RuneAttribute(value="fallbackBondApplicable", isRequired=true)
        public Boolean getFallbackBondApplicable() {
            return this.fallbackBondApplicable;
        }

        @Override
        @RosettaAttribute(value="calculationMethod")
        @RuneAttribute(value="calculationMethod")
        public InflationCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="calculationStyle")
        @RuneAttribute(value="calculationStyle")
        public InflationCalculationStyleEnum getCalculationStyle() {
            return this.calculationStyle;
        }

        @Override
        @RosettaAttribute(value="finalPrincipalExchangeCalculation")
        @RuneAttribute(value="finalPrincipalExchangeCalculation")
        public FinalPrincipalExchangeCalculationEnum getFinalPrincipalExchangeCalculation() {
            return this.finalPrincipalExchangeCalculation;
        }

        @Override
        @RosettaAttribute(value="rateOption")
        @RuneAttribute(value="rateOption")
        @RuneScopedAttributeReference
        public InflationRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption _rateOption) {
            this.rateOption = _rateOption == null ? null : _rateOption.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setRateOptionValue(FloatingRateOption _rateOption) {
            this.getOrCreateRateOption().setValue(_rateOption);
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public InflationRateSpecificationBuilder setSpreadSchedule(SpreadSchedule _spreadSchedule) {
            this.spreadSchedule = _spreadSchedule == null ? null : _spreadSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public InflationRateSpecificationBuilder setCapRateSchedule(StrikeSchedule _capRateSchedule) {
            this.capRateSchedule = _capRateSchedule == null ? null : _capRateSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public InflationRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule _floorRateSchedule) {
            this.floorRateSchedule = _floorRateSchedule == null ? null : _floorRateSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public InflationRateSpecificationBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public InflationRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule _floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = _floatingRateMultiplierSchedule == null ? null : _floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public InflationRateSpecificationBuilder setRateTreatment(RateTreatmentEnum _rateTreatment) {
            this.rateTreatment = _rateTreatment == null ? null : _rateTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationParameters")
        @RuneAttribute(value="calculationParameters")
        public InflationRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters _calculationParameters) {
            this.calculationParameters = _calculationParameters == null ? null : _calculationParameters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackRate")
        @RuneAttribute(value="fallbackRate")
        public InflationRateSpecificationBuilder setFallbackRate(FallbackRateParameters _fallbackRate) {
            this.fallbackRate = _fallbackRate == null ? null : _fallbackRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialRate")
        @RuneAttribute(value="initialRate")
        public InflationRateSpecificationBuilder setInitialRate(Price _initialRate) {
            this.initialRate = _initialRate == null ? null : _initialRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalRateRounding")
        @RuneAttribute(value="finalRateRounding")
        public InflationRateSpecificationBuilder setFinalRateRounding(Rounding _finalRateRounding) {
            this.finalRateRounding = _finalRateRounding == null ? null : _finalRateRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public InflationRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="negativeInterestRateTreatment")
        @RuneAttribute(value="negativeInterestRateTreatment")
        public InflationRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum _negativeInterestRateTreatment) {
            this.negativeInterestRateTreatment = _negativeInterestRateTreatment == null ? null : _negativeInterestRateTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="inflationLag", isRequired=true)
        @RuneAttribute(value="inflationLag", isRequired=true)
        public InflationRateSpecificationBuilder setInflationLag(Offset _inflationLag) {
            this.inflationLag = _inflationLag == null ? null : _inflationLag.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexSource", isRequired=true)
        @RuneAttribute(value="indexSource", isRequired=true)
        public InflationRateSpecificationBuilder setIndexSource(FieldWithMetaString _indexSource) {
            this.indexSource = _indexSource == null ? null : _indexSource.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setIndexSourceValue(String _indexSource) {
            this.getOrCreateIndexSource().setValue(_indexSource);
            return this;
        }

        @Override
        @RosettaAttribute(value="mainPublication", isRequired=true)
        @RuneAttribute(value="mainPublication", isRequired=true)
        public InflationRateSpecificationBuilder setMainPublication(FieldWithMetaString _mainPublication) {
            this.mainPublication = _mainPublication == null ? null : _mainPublication.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setMainPublicationValue(String _mainPublication) {
            this.getOrCreateMainPublication().setValue(_mainPublication);
            return this;
        }

        @Override
        @RosettaAttribute(value="interpolationMethod", isRequired=true)
        @RuneAttribute(value="interpolationMethod", isRequired=true)
        public InflationRateSpecificationBuilder setInterpolationMethod(FieldWithMetaInterpolationMethodEnum _interpolationMethod) {
            this.interpolationMethod = _interpolationMethod == null ? null : _interpolationMethod.toBuilder();
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder setInterpolationMethodValue(InterpolationMethodEnum _interpolationMethod) {
            this.getOrCreateInterpolationMethod().setValue(_interpolationMethod);
            return this;
        }

        @Override
        @RosettaAttribute(value="initialIndexLevel")
        @RuneAttribute(value="initialIndexLevel")
        public InflationRateSpecificationBuilder setInitialIndexLevel(BigDecimal _initialIndexLevel) {
            this.initialIndexLevel = _initialIndexLevel == null ? null : _initialIndexLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackBondApplicable", isRequired=true)
        @RuneAttribute(value="fallbackBondApplicable", isRequired=true)
        public InflationRateSpecificationBuilder setFallbackBondApplicable(Boolean _fallbackBondApplicable) {
            this.fallbackBondApplicable = _fallbackBondApplicable == null ? null : _fallbackBondApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationMethod")
        @RuneAttribute(value="calculationMethod")
        public InflationRateSpecificationBuilder setCalculationMethod(InflationCalculationMethodEnum _calculationMethod) {
            this.calculationMethod = _calculationMethod == null ? null : _calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationStyle")
        @RuneAttribute(value="calculationStyle")
        public InflationRateSpecificationBuilder setCalculationStyle(InflationCalculationStyleEnum _calculationStyle) {
            this.calculationStyle = _calculationStyle == null ? null : _calculationStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalPrincipalExchangeCalculation")
        @RuneAttribute(value="finalPrincipalExchangeCalculation")
        public InflationRateSpecificationBuilder setFinalPrincipalExchangeCalculation(FinalPrincipalExchangeCalculationEnum _finalPrincipalExchangeCalculation) {
            this.finalPrincipalExchangeCalculation = _finalPrincipalExchangeCalculation == null ? null : _finalPrincipalExchangeCalculation;
            return this;
        }

        @Override
        public InflationRateSpecification build() {
            return new InflationRateSpecificationImpl(this);
        }

        @Override
        public InflationRateSpecificationBuilder toBuilder() {
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder prune() {
            super.prune();
            if (this.inflationLag != null && !this.inflationLag.prune().hasData()) {
                this.inflationLag = null;
            }
            if (this.indexSource != null && !this.indexSource.prune().hasData()) {
                this.indexSource = null;
            }
            if (this.mainPublication != null && !this.mainPublication.prune().hasData()) {
                this.mainPublication = null;
            }
            if (this.interpolationMethod != null && !this.interpolationMethod.prune().hasData()) {
                this.interpolationMethod = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInflationLag() != null && this.getInflationLag().hasData()) {
                return true;
            }
            if (this.getIndexSource() != null) {
                return true;
            }
            if (this.getMainPublication() != null) {
                return true;
            }
            if (this.getInterpolationMethod() != null) {
                return true;
            }
            if (this.getInitialIndexLevel() != null) {
                return true;
            }
            if (this.getFallbackBondApplicable() != null) {
                return true;
            }
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getCalculationStyle() != null) {
                return true;
            }
            return this.getFinalPrincipalExchangeCalculation() != null;
        }

        @Override
        public InflationRateSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InflationRateSpecificationBuilder o = (InflationRateSpecificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInflationLag(), (RosettaModelObjectBuilder)o.getInflationLag(), this::setInflationLag);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexSource(), (RosettaModelObjectBuilder)o.getIndexSource(), this::setIndexSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMainPublication(), (RosettaModelObjectBuilder)o.getMainPublication(), this::setMainPublication);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterpolationMethod(), (RosettaModelObjectBuilder)o.getInterpolationMethod(), this::setInterpolationMethod);
            merger.mergeBasic((Object)this.getInitialIndexLevel(), (Object)o.getInitialIndexLevel(), this::setInitialIndexLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFallbackBondApplicable(), (Object)o.getFallbackBondApplicable(), this::setFallbackBondApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculationStyle(), (Object)o.getCalculationStyle(), this::setCalculationStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalPrincipalExchangeCalculation(), (Object)o.getFinalPrincipalExchangeCalculation(), this::setFinalPrincipalExchangeCalculation, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationRateSpecification _that = (InflationRateSpecification)this.getType().cast(o);
            if (!Objects.equals(this.inflationLag, _that.getInflationLag())) {
                return false;
            }
            if (!Objects.equals(this.indexSource, _that.getIndexSource())) {
                return false;
            }
            if (!Objects.equals(this.mainPublication, _that.getMainPublication())) {
                return false;
            }
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            if (!Objects.equals(this.initialIndexLevel, _that.getInitialIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.fallbackBondApplicable, _that.getFallbackBondApplicable())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationStyle, (Object)_that.getCalculationStyle())) {
                return false;
            }
            return Objects.equals((Object)this.finalPrincipalExchangeCalculation, (Object)_that.getFinalPrincipalExchangeCalculation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inflationLag != null ? this.inflationLag.hashCode() : 0);
            _result = 31 * _result + (this.indexSource != null ? this.indexSource.hashCode() : 0);
            _result = 31 * _result + (this.mainPublication != null ? this.mainPublication.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.initialIndexLevel != null ? this.initialIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.fallbackBondApplicable != null ? this.fallbackBondApplicable.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.calculationStyle != null ? ((Object)((Object)this.calculationStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalPrincipalExchangeCalculation != null ? ((Object)((Object)this.finalPrincipalExchangeCalculation)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationRateSpecificationBuilder {inflationLag=" + this.inflationLag + ", indexSource=" + this.indexSource + ", mainPublication=" + this.mainPublication + ", interpolationMethod=" + this.interpolationMethod + ", initialIndexLevel=" + this.initialIndexLevel + ", fallbackBondApplicable=" + this.fallbackBondApplicable + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", calculationStyle=" + (Object)((Object)this.calculationStyle) + ", finalPrincipalExchangeCalculation=" + (Object)((Object)this.finalPrincipalExchangeCalculation) + '}' + " " + super.toString();
        }
    }

    public static interface InflationRateSpecificationBuilder
    extends InflationRateSpecification,
    FloatingRateSpecification.FloatingRateSpecificationBuilder {
        public Offset.OffsetBuilder getOrCreateInflationLag();

        @Override
        public Offset.OffsetBuilder getInflationLag();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIndexSource();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIndexSource();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateMainPublication();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getMainPublication();

        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getOrCreateInterpolationMethod();

        @Override
        public FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder getInterpolationMethod();

        @Override
        public InflationRateSpecificationBuilder setRateOption(ReferenceWithMetaFloatingRateOption var1);

        @Override
        public InflationRateSpecificationBuilder setRateOptionValue(FloatingRateOption var1);

        @Override
        public InflationRateSpecificationBuilder setSpreadSchedule(SpreadSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setCapRateSchedule(StrikeSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setFloorRateSchedule(StrikeSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setMeta(MetaFields var1);

        @Override
        public InflationRateSpecificationBuilder setFloatingRateMultiplierSchedule(RateSchedule var1);

        @Override
        public InflationRateSpecificationBuilder setRateTreatment(RateTreatmentEnum var1);

        @Override
        public InflationRateSpecificationBuilder setCalculationParameters(FloatingRateCalculationParameters var1);

        @Override
        public InflationRateSpecificationBuilder setFallbackRate(FallbackRateParameters var1);

        @Override
        public InflationRateSpecificationBuilder setInitialRate(Price var1);

        @Override
        public InflationRateSpecificationBuilder setFinalRateRounding(Rounding var1);

        @Override
        public InflationRateSpecificationBuilder setAveragingMethod(AveragingWeightingMethodEnum var1);

        @Override
        public InflationRateSpecificationBuilder setNegativeInterestRateTreatment(NegativeInterestRateTreatmentEnum var1);

        public InflationRateSpecificationBuilder setInflationLag(Offset var1);

        public InflationRateSpecificationBuilder setIndexSource(FieldWithMetaString var1);

        public InflationRateSpecificationBuilder setIndexSourceValue(String var1);

        public InflationRateSpecificationBuilder setMainPublication(FieldWithMetaString var1);

        public InflationRateSpecificationBuilder setMainPublicationValue(String var1);

        public InflationRateSpecificationBuilder setInterpolationMethod(FieldWithMetaInterpolationMethodEnum var1);

        public InflationRateSpecificationBuilder setInterpolationMethodValue(InterpolationMethodEnum var1);

        public InflationRateSpecificationBuilder setInitialIndexLevel(BigDecimal var1);

        public InflationRateSpecificationBuilder setFallbackBondApplicable(Boolean var1);

        public InflationRateSpecificationBuilder setCalculationMethod(InflationCalculationMethodEnum var1);

        public InflationRateSpecificationBuilder setCalculationStyle(InflationCalculationStyleEnum var1);

        public InflationRateSpecificationBuilder setFinalPrincipalExchangeCalculation(FinalPrincipalExchangeCalculationEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("rateOption"), processor, ReferenceWithMetaFloatingRateOption.ReferenceWithMetaFloatingRateOptionBuilder.class, (RosettaModelObjectBuilder)this.getRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.SpreadScheduleBuilder.class, (RosettaModelObjectBuilder)this.getSpreadSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, (RosettaModelObjectBuilder)this.getCapRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, (RosettaModelObjectBuilder)this.getFloorRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, RateSchedule.RateScheduleBuilder.class, (RosettaModelObjectBuilder)this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationParameters"), processor, FloatingRateCalculationParameters.FloatingRateCalculationParametersBuilder.class, (RosettaModelObjectBuilder)this.getCalculationParameters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackRate"), processor, FallbackRateParameters.FallbackRateParametersBuilder.class, (RosettaModelObjectBuilder)this.getFallbackRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialRate"), processor, Price.PriceBuilder.class, (RosettaModelObjectBuilder)this.getInitialRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalRateRounding"), processor, Rounding.RoundingBuilder.class, (RosettaModelObjectBuilder)this.getFinalRateRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingWeightingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("negativeInterestRateTreatment"), NegativeInterestRateTreatmentEnum.class, (Object)this.getNegativeInterestRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inflationLag"), processor, Offset.OffsetBuilder.class, this.getInflationLag(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexSource"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getIndexSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("mainPublication"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getMainPublication(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interpolationMethod"), processor, FieldWithMetaInterpolationMethodEnum.FieldWithMetaInterpolationMethodEnumBuilder.class, this.getInterpolationMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialIndexLevel"), BigDecimal.class, (Object)this.getInitialIndexLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fallbackBondApplicable"), Boolean.class, (Object)this.getFallbackBondApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationMethod"), InflationCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationStyle"), InflationCalculationStyleEnum.class, (Object)this.getCalculationStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalPrincipalExchangeCalculation"), FinalPrincipalExchangeCalculationEnum.class, (Object)this.getFinalPrincipalExchangeCalculation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public InflationRateSpecificationBuilder prune();
    }

    public static class InflationRateSpecificationImpl
    extends FloatingRateSpecification.FloatingRateSpecificationImpl
    implements InflationRateSpecification {
        private final Offset inflationLag;
        private final FieldWithMetaString indexSource;
        private final FieldWithMetaString mainPublication;
        private final FieldWithMetaInterpolationMethodEnum interpolationMethod;
        private final BigDecimal initialIndexLevel;
        private final Boolean fallbackBondApplicable;
        private final InflationCalculationMethodEnum calculationMethod;
        private final InflationCalculationStyleEnum calculationStyle;
        private final FinalPrincipalExchangeCalculationEnum finalPrincipalExchangeCalculation;

        protected InflationRateSpecificationImpl(InflationRateSpecificationBuilder builder) {
            super(builder);
            this.inflationLag = Optional.ofNullable(builder.getInflationLag()).map(f -> f.build()).orElse(null);
            this.indexSource = Optional.ofNullable(builder.getIndexSource()).map(f -> f.build()).orElse(null);
            this.mainPublication = Optional.ofNullable(builder.getMainPublication()).map(f -> f.build()).orElse(null);
            this.interpolationMethod = Optional.ofNullable(builder.getInterpolationMethod()).map(f -> f.build()).orElse(null);
            this.initialIndexLevel = builder.getInitialIndexLevel();
            this.fallbackBondApplicable = builder.getFallbackBondApplicable();
            this.calculationMethod = builder.getCalculationMethod();
            this.calculationStyle = builder.getCalculationStyle();
            this.finalPrincipalExchangeCalculation = builder.getFinalPrincipalExchangeCalculation();
        }

        @Override
        @RosettaAttribute(value="inflationLag", isRequired=true)
        @RuneAttribute(value="inflationLag", isRequired=true)
        public Offset getInflationLag() {
            return this.inflationLag;
        }

        @Override
        @RosettaAttribute(value="indexSource", isRequired=true)
        @RuneAttribute(value="indexSource", isRequired=true)
        public FieldWithMetaString getIndexSource() {
            return this.indexSource;
        }

        @Override
        @RosettaAttribute(value="mainPublication", isRequired=true)
        @RuneAttribute(value="mainPublication", isRequired=true)
        public FieldWithMetaString getMainPublication() {
            return this.mainPublication;
        }

        @Override
        @RosettaAttribute(value="interpolationMethod", isRequired=true)
        @RuneAttribute(value="interpolationMethod", isRequired=true)
        public FieldWithMetaInterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        @RosettaAttribute(value="initialIndexLevel")
        @RuneAttribute(value="initialIndexLevel")
        public BigDecimal getInitialIndexLevel() {
            return this.initialIndexLevel;
        }

        @Override
        @RosettaAttribute(value="fallbackBondApplicable", isRequired=true)
        @RuneAttribute(value="fallbackBondApplicable", isRequired=true)
        public Boolean getFallbackBondApplicable() {
            return this.fallbackBondApplicable;
        }

        @Override
        @RosettaAttribute(value="calculationMethod")
        @RuneAttribute(value="calculationMethod")
        public InflationCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="calculationStyle")
        @RuneAttribute(value="calculationStyle")
        public InflationCalculationStyleEnum getCalculationStyle() {
            return this.calculationStyle;
        }

        @Override
        @RosettaAttribute(value="finalPrincipalExchangeCalculation")
        @RuneAttribute(value="finalPrincipalExchangeCalculation")
        public FinalPrincipalExchangeCalculationEnum getFinalPrincipalExchangeCalculation() {
            return this.finalPrincipalExchangeCalculation;
        }

        @Override
        public InflationRateSpecification build() {
            return this;
        }

        @Override
        public InflationRateSpecificationBuilder toBuilder() {
            InflationRateSpecificationBuilder builder = InflationRateSpecification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InflationRateSpecificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInflationLag()).ifPresent(builder::setInflationLag);
            Optional.ofNullable(this.getIndexSource()).ifPresent(builder::setIndexSource);
            Optional.ofNullable(this.getMainPublication()).ifPresent(builder::setMainPublication);
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
            Optional.ofNullable(this.getInitialIndexLevel()).ifPresent(builder::setInitialIndexLevel);
            Optional.ofNullable(this.getFallbackBondApplicable()).ifPresent(builder::setFallbackBondApplicable);
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getCalculationStyle()).ifPresent(builder::setCalculationStyle);
            Optional.ofNullable(this.getFinalPrincipalExchangeCalculation()).ifPresent(builder::setFinalPrincipalExchangeCalculation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InflationRateSpecification _that = (InflationRateSpecification)this.getType().cast(o);
            if (!Objects.equals(this.inflationLag, _that.getInflationLag())) {
                return false;
            }
            if (!Objects.equals(this.indexSource, _that.getIndexSource())) {
                return false;
            }
            if (!Objects.equals(this.mainPublication, _that.getMainPublication())) {
                return false;
            }
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            if (!Objects.equals(this.initialIndexLevel, _that.getInitialIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.fallbackBondApplicable, _that.getFallbackBondApplicable())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationStyle, (Object)_that.getCalculationStyle())) {
                return false;
            }
            return Objects.equals((Object)this.finalPrincipalExchangeCalculation, (Object)_that.getFinalPrincipalExchangeCalculation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.inflationLag != null ? this.inflationLag.hashCode() : 0);
            _result = 31 * _result + (this.indexSource != null ? this.indexSource.hashCode() : 0);
            _result = 31 * _result + (this.mainPublication != null ? this.mainPublication.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.initialIndexLevel != null ? this.initialIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.fallbackBondApplicable != null ? this.fallbackBondApplicable.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.calculationStyle != null ? ((Object)((Object)this.calculationStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalPrincipalExchangeCalculation != null ? ((Object)((Object)this.finalPrincipalExchangeCalculation)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InflationRateSpecification {inflationLag=" + this.inflationLag + ", indexSource=" + this.indexSource + ", mainPublication=" + this.mainPublication + ", interpolationMethod=" + this.interpolationMethod + ", initialIndexLevel=" + this.initialIndexLevel + ", fallbackBondApplicable=" + this.fallbackBondApplicable + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", calculationStyle=" + (Object)((Object)this.calculationStyle) + ", finalPrincipalExchangeCalculation=" + (Object)((Object)this.finalPrincipalExchangeCalculation) + '}' + " " + super.toString();
        }
    }
}

