/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.StubValue;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StubValueOneOf0")
@ImplementedBy(value=Default.class)
public interface StubValueOneOf0
extends Validator<StubValue> {
    public static final String NAME = "StubValueOneOf0";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements StubValueOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StubValue stubValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StubValueOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StubValue stubValue) {
            ComparisonResult result = this.executeDataRule(stubValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StubValueOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StubValue", (RosettaPath)path, (String)StubValueOneOf0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StubValueOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StubValue", (RosettaPath)path, (String)StubValueOneOf0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StubValue stubValue) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)stubValue), Arrays.asList("floatingRate", "stubRate", "stubAmount"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

